#!/usr/bin/env ruby

summary_tests = File.join(__dir__, "..", "test", "summary_tests.c")
summary_tests_list = File.join(__dir__, "..", "test", "summary_tests_list.c")

is_fn_decl = -> (l) { l.start_with?('void ') }
get_fn_name = -> (l) { l.split(' ')[1].split('(')[0] }
to_ref = -> (n) { "&#{n}," }

fns = File.readlines(summary_tests).filter(&is_fn_decl).map(&get_fn_name).map(&to_ref)

lines = ["// Generated by #{__FILE__}", "", *fns, ""]

File.write(summary_tests_list, lines.join("\n"))
