/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Imagination E5010 JPEG Encoder driver.
 *
 * Copyright (C) 2023 Texas Instruments Incorporated - https://www.ti.com/
 *
 * Author: David Huang <d-huang@ti.com>
 * Author: Devarsh Thakkar <devarsht@ti.com>
 */

#ifndef _E5010_MMU_REGS_H
#define _E5010_MMU_REGS_H

#define MMU_MMU_DIR_BASE_ADDR_OFFSET					(0x0020)
#define MMU_MMU_DIR_BASE_ADDR_STRIDE					(4)
#define MMU_MMU_DIR_BASE_ADDR_NO_ENTRIES				(4)

#define MMU_MMU_DIR_BASE_ADDR_MMU_DIR_BASE_ADDR_MASK			(0xFFFFFFFF)
#define MMU_MMU_DIR_BASE_ADDR_MMU_DIR_BASE_ADDR_SHIFT			(0)

#define MMU_MMU_TILE_CFG_OFFSET						(0x0040)
#define MMU_MMU_TILE_CFG_STRIDE						(4)
#define MMU_MMU_TILE_CFG_NO_ENTRIES					(4)

#define MMU_MMU_TILE_CFG_TILE_128INTERLEAVE_MASK			(0x00000010)
#define MMU_MMU_TILE_CFG_TILE_128INTERLEAVE_SHIFT			(4)

#define MMU_MMU_TILE_CFG_TILE_ENABLE_MASK				(0x00000008)
#define MMU_MMU_TILE_CFG_TILE_ENABLE_SHIFT				(3)

#define MMU_MMU_TILE_CFG_TILE_STRIDE_MASK				(0x00000007)
#define MMU_MMU_TILE_CFG_TILE_STRIDE_SHIFT				(0)

#define MMU_MMU_TILE_MIN_ADDR_OFFSET					(0x0050)
#define MMU_MMU_TILE_MIN_ADDR_STRIDE					(4)
#define MMU_MMU_TILE_MIN_ADDR_NO_ENTRIES				(4)

#define MMU_MMU_TILE_MIN_ADDR_TILE_MIN_ADDR_MASK			(0xFFFFFFFF)
#define MMU_MMU_TILE_MIN_ADDR_TILE_MIN_ADDR_SHIFT			(0)

#define MMU_MMU_TILE_MAX_ADDR_OFFSET					(0x0060)
#define MMU_MMU_TILE_MAX_ADDR_STRIDE					(4)
#define MMU_MMU_TILE_MAX_ADDR_NO_ENTRIES				(4)

#define MMU_MMU_TILE_MAX_ADDR_TILE_MAX_ADDR_MASK			(0xFFFFFFFF)
#define MMU_MMU_TILE_MAX_ADDR_TILE_MAX_ADDR_SHIFT			(0)

#define MMU_MMU_CONTROL0_OFFSET						(0x0000)

#define MMU_MMU_CONTROL0_MMU_TILING_SCHEME_MASK				(0x00000001)
#define MMU_MMU_CONTROL0_MMU_TILING_SCHEME_SHIFT			(0)

#define MMU_MMU_CONTROL0_MMU_CACHE_POLICY_MASK				(0x00000100)
#define MMU_MMU_CONTROL0_MMU_CACHE_POLICY_SHIFT				(8)

#define MMU_MMU_CONTROL0_FORCE_CACHE_POLICY_BYPASS_MASK			(0x00000200)
#define MMU_MMU_CONTROL0_FORCE_CACHE_POLICY_BYPASS_SHIFT		(9)

#define MMU_MMU_CONTROL0_STALL_ON_PROTOCOL_FAULT_MASK			(0x00001000)
#define MMU_MMU_CONTROL0_STALL_ON_PROTOCOL_FAULT_SHIFT			(12)

#define MMU_MMU_CONTROL1_OFFSET						(0x0008)

#define MMU_MMU_CONTROL1_MMU_FLUSH_MASK					(0x00000008)
#define MMU_MMU_CONTROL1_MMU_FLUSH_SHIFT				(3)
#define MMU_MMU_CONTROL1_MMU_FLUSH_NO_REPS				(4)
#define MMU_MMU_CONTROL1_MMU_FLUSH_SIZE					(1)

#define MMU_MMU_CONTROL1_MMU_INVALDC_MASK				(0x00000800)
#define MMU_MMU_CONTROL1_MMU_INVALDC_SHIFT				(11)
#define MMU_MMU_CONTROL1_MMU_INVALDC_NO_REPS				(4)
#define MMU_MMU_CONTROL1_MMU_INVALDC_SIZE				(1)

#define MMU_MMU_CONTROL1_MMU_FAULT_CLEAR_MASK				(0x00010000)
#define MMU_MMU_CONTROL1_MMU_FAULT_CLEAR_SHIFT				(16)

#define MMU_MMU_CONTROL1_PROTOCOL_FAULT_CLEAR_MASK			(0x00100000)
#define MMU_MMU_CONTROL1_PROTOCOL_FAULT_CLEAR_SHIFT			(20)

#define MMU_MMU_CONTROL1_MMU_PAUSE_SET_MASK				(0x01000000)
#define MMU_MMU_CONTROL1_MMU_PAUSE_SET_SHIFT				(24)

#define MMU_MMU_CONTROL1_MMU_PAUSE_CLEAR_MASK				(0x02000000)
#define MMU_MMU_CONTROL1_MMU_PAUSE_CLEAR_SHIFT				(25)

#define MMU_MMU_CONTROL1_MMU_SOFT_RESET_MASK				(0x10000000)
#define MMU_MMU_CONTROL1_MMU_SOFT_RESET_SHIFT				(28)

#define MMU_MMU_BANK_INDEX_OFFSET					(0x0010)

#define MMU_MMU_BANK_INDEX_MMU_BANK_INDEX_MASK				(0xC0000000)
#define MMU_MMU_BANK_INDEX_MMU_BANK_INDEX_SHIFT				(30)
#define MMU_MMU_BANK_INDEX_MMU_BANK_INDEX_NO_REPS			(16)
#define MMU_MMU_BANK_INDEX_MMU_BANK_INDEX_SIZE				(2)

#define MMU_REQUEST_PRIORITY_ENABLE_OFFSET				(0x0018)

#define MMU_REQUEST_PRIORITY_ENABLE_CMD_PRIORITY_ENABLE_MASK		(0x00008000)
#define MMU_REQUEST_PRIORITY_ENABLE_CMD_PRIORITY_ENABLE_SHIFT		(15)
#define MMU_REQUEST_PRIORITY_ENABLE_CMD_PRIORITY_ENABLE_NO_REPS		(16)
#define MMU_REQUEST_PRIORITY_ENABLE_CMD_PRIORITY_ENABLE_SIZE		(1)

#define MMU_REQUEST_PRIORITY_ENABLE_CMD_MMU_PRIORITY_ENABLE_MASK	(0x00010000)
#define MMU_REQUEST_PRIORITY_ENABLE_CMD_MMU_PRIORITY_ENABLE_SHIFT	(16)

#define MMU_REQUEST_LIMITED_THROUGHPUT_OFFSET				(0x001C)

#define MMU_REQUEST_LIMITED_THROUGHPUT_LIMITED_WORDS_MASK		(0x000003FF)
#define MMU_REQUEST_LIMITED_THROUGHPUT_LIMITED_WORDS_SHIFT		(0)

#define MMU_REQUEST_LIMITED_THROUGHPUT_REQUEST_GAP_MASK			(0x0FFF0000)
#define MMU_REQUEST_LIMITED_THROUGHPUT_REQUEST_GAP_SHIFT		(16)

#define MMU_MMU_ADDRESS_CONTROL_OFFSET					(0x0070)
#define MMU_MMU_ADDRESS_CONTROL_TRUSTED					(IMG_TRUE)

#define MMU_MMU_ADDRESS_CONTROL_MMU_BYPASS_MASK				(0x00000001)
#define MMU_MMU_ADDRESS_CONTROL_MMU_BYPASS_SHIFT			(0)

#define MMU_MMU_ADDRESS_CONTROL_MMU_ENABLE_EXT_ADDRESSING_MASK		(0x00000010)
#define MMU_MMU_ADDRESS_CONTROL_MMU_ENABLE_EXT_ADDRESSING_SHIFT		(4)

#define MMU_MMU_ADDRESS_CONTROL_UPPER_ADDRESS_FIXED_MASK		(0x00FF0000)
#define MMU_MMU_ADDRESS_CONTROL_UPPER_ADDRESS_FIXED_SHIFT		(16)

#define MMU_MMU_CONFIG0_OFFSET						(0x0080)

#define MMU_MMU_CONFIG0_NUM_REQUESTORS_MASK				(0x0000000F)
#define MMU_MMU_CONFIG0_NUM_REQUESTORS_SHIFT				(0)

#define MMU_MMU_CONFIG0_EXTENDED_ADDR_RANGE_MASK			(0x000000F0)
#define MMU_MMU_CONFIG0_EXTENDED_ADDR_RANGE_SHIFT			(4)

#define MMU_MMU_CONFIG0_GROUP_OVERRIDE_SIZE_MASK			(0x00000700)
#define MMU_MMU_CONFIG0_GROUP_OVERRIDE_SIZE_SHIFT			(8)

#define MMU_MMU_CONFIG0_ADDR_COHERENCY_SUPPORTED_MASK			(0x00001000)
#define MMU_MMU_CONFIG0_ADDR_COHERENCY_SUPPORTED_SHIFT			(12)

#define MMU_MMU_CONFIG0_MMU_SUPPORTED_MASK				(0x00002000)
#define MMU_MMU_CONFIG0_MMU_SUPPORTED_SHIFT				(13)

#define MMU_MMU_CONFIG0_TILE_ADDR_GRANULARITY_MASK			(0x001F0000)
#define MMU_MMU_CONFIG0_TILE_ADDR_GRANULARITY_SHIFT			(16)

#define MMU_MMU_CONFIG0_NO_READ_REORDER_MASK				(0x00200000)
#define MMU_MMU_CONFIG0_NO_READ_REORDER_SHIFT				(21)

#define MMU_MMU_CONFIG0_TAGS_SUPPORTED_MASK				(0xFFC00000)
#define MMU_MMU_CONFIG0_TAGS_SUPPORTED_SHIFT				(22)

#define MMU_MMU_CONFIG1_OFFSET						(0x0084)

#define MMU_MMU_CONFIG1_PAGE_SIZE_MASK					(0x0000000F)
#define MMU_MMU_CONFIG1_PAGE_SIZE_SHIFT					(0)

#define MMU_MMU_CONFIG1_PAGE_CACHE_ENTRIES_MASK				(0x0000FF00)
#define MMU_MMU_CONFIG1_PAGE_CACHE_ENTRIES_SHIFT			(8)

#define MMU_MMU_CONFIG1_DIR_CACHE_ENTRIES_MASK				(0x001F0000)
#define MMU_MMU_CONFIG1_DIR_CACHE_ENTRIES_SHIFT				(16)

#define MMU_MMU_CONFIG1_BANDWIDTH_COUNT_SUPPORTED_MASK			(0x01000000)
#define MMU_MMU_CONFIG1_BANDWIDTH_COUNT_SUPPORTED_SHIFT			(24)

#define MMU_MMU_CONFIG1_STALL_COUNT_SUPPORTED_MASK			(0x02000000)
#define MMU_MMU_CONFIG1_STALL_COUNT_SUPPORTED_SHIFT			(25)

#define MMU_MMU_CONFIG1_LATENCY_COUNT_SUPPORTED_MASK			(0x04000000)
#define MMU_MMU_CONFIG1_LATENCY_COUNT_SUPPORTED_SHIFT			(26)

#define MMU_MMU_STATUS0_OFFSET						(0x0088)

#define MMU_MMU_STATUS0_MMU_PF_N_RW_MASK				(0x00000001)
#define MMU_MMU_STATUS0_MMU_PF_N_RW_SHIFT				(0)

#define MMU_MMU_STATUS0_MMU_FAULT_ADDR_MASK				(0xFFFFF000)
#define MMU_MMU_STATUS0_MMU_FAULT_ADDR_SHIFT				(12)

#define MMU_MMU_STATUS1_OFFSET						(0x008C)

#define MMU_MMU_STATUS1_MMU_FAULT_REQ_STAT_MASK				(0x0000FFFF)
#define MMU_MMU_STATUS1_MMU_FAULT_REQ_STAT_SHIFT			(0)

#define MMU_MMU_STATUS1_MMU_FAULT_REQ_ID_MASK				(0x000F0000)
#define MMU_MMU_STATUS1_MMU_FAULT_REQ_ID_SHIFT				(16)

#define MMU_MMU_STATUS1_MMU_FAULT_INDEX_MASK				(0x03000000)
#define MMU_MMU_STATUS1_MMU_FAULT_INDEX_SHIFT				(24)

#define MMU_MMU_STATUS1_MMU_FAULT_RNW_MASK				(0x10000000)
#define MMU_MMU_STATUS1_MMU_FAULT_RNW_SHIFT				(28)

#define MMU_MMU_MEM_REQ_OFFSET						(0x0090)

#define MMU_MMU_MEM_REQ_TAG_OUTSTANDING_MASK				(0x000003FF)
#define MMU_MMU_MEM_REQ_TAG_OUTSTANDING_SHIFT				(0)

#define MMU_MMU_MEM_REQ_EXT_WRRESP_FAULT_MASK				(0x00001000)
#define MMU_MMU_MEM_REQ_EXT_WRRESP_FAULT_SHIFT				(12)

#define MMU_MMU_MEM_REQ_EXT_RDRESP_FAULT_MASK				(0x00002000)
#define MMU_MMU_MEM_REQ_EXT_RDRESP_FAULT_SHIFT				(13)

#define MMU_MMU_MEM_REQ_EXT_READ_BURST_FAULT_MASK			(0x00004000)
#define MMU_MMU_MEM_REQ_EXT_READ_BURST_FAULT_SHIFT			(14)

#define MMU_MMU_MEM_REQ_INT_PROTOCOL_FAULT_MASK				(0x80000000)
#define MMU_MMU_MEM_REQ_INT_PROTOCOL_FAULT_SHIFT			(31)
#define MMU_MMU_MEM_REQ_INT_PROTOCOL_FAULT_NO_REPS			(16)
#define MMU_MMU_MEM_REQ_INT_PROTOCOL_FAULT_SIZE				(1)

#define MMU_MMU_FAULT_SELECT_OFFSET					(0x00A0)

#define MMU_MMU_FAULT_SELECT_MMU_FAULT_SELECT_MASK			(0x0000000F)
#define MMU_MMU_FAULT_SELECT_MMU_FAULT_SELECT_SHIFT			(0)

#define MMU_PROTOCOL_FAULT_OFFSET					(0x00A8)

#define MMU_PROTOCOL_FAULT_FAULT_PAGE_BREAK_MASK			(0x00000001)
#define MMU_PROTOCOL_FAULT_FAULT_PAGE_BREAK_SHIFT			(0)

#define MMU_PROTOCOL_FAULT_FAULT_WRITE_MASK				(0x00000010)
#define MMU_PROTOCOL_FAULT_FAULT_WRITE_SHIFT				(4)

#define MMU_PROTOCOL_FAULT_FAULT_READ_MASK				(0x00000020)
#define MMU_PROTOCOL_FAULT_FAULT_READ_SHIFT				(5)

#define MMU_TOTAL_READ_REQ_OFFSET					(0x0100)

#define MMU_TOTAL_READ_REQ_TOTAL_READ_REQ_MASK				(0xFFFFFFFF)
#define MMU_TOTAL_READ_REQ_TOTAL_READ_REQ_SHIFT				(0)

#define MMU_TOTAL_WRITE_REQ_OFFSET					(0x0104)

#define MMU_TOTAL_WRITE_REQ_TOTAL_WRITE_REQ_MASK			(0xFFFFFFFF)
#define MMU_TOTAL_WRITE_REQ_TOTAL_WRITE_REQ_SHIFT			(0)

#define MMU_READS_LESS_64_REQ_OFFSET					(0x0108)

#define MMU_READS_LESS_64_REQ_READS_LESS_64_REQ_MASK			(0xFFFFFFFF)
#define MMU_READS_LESS_64_REQ_READS_LESS_64_REQ_SHIFT			(0)

#define MMU_WRITES_LESS_64_REQ_OFFSET					(0x010C)

#define MMU_WRITES_LESS_64_REQ_WRITES_LESS_64_REQ_MASK			(0xFFFFFFFF)
#define MMU_WRITES_LESS_64_REQ_WRITES_LESS_64_REQ_SHIFT			(0)

#define MMU_EXT_CMD_STALL_OFFSET					(0x0120)

#define MMU_EXT_CMD_STALL_EXT_CMD_STALL_MASK				(0xFFFFFFFF)
#define MMU_EXT_CMD_STALL_EXT_CMD_STALL_SHIFT				(0)

#define MMU_WRITE_REQ_STALL_OFFSET					(0x0124)

#define MMU_WRITE_REQ_STALL_WRITE_REQ_STALL_MASK			(0xFFFFFFFF)
#define MMU_WRITE_REQ_STALL_WRITE_REQ_STALL_SHIFT			(0)

#define MMU_MMU_MISS_STALL_OFFSET					(0x0128)

#define MMU_MMU_MISS_STALL_MMU_MISS_STALL_MASK				(0xFFFFFFFF)
#define MMU_MMU_MISS_STALL_MMU_MISS_STALL_SHIFT				(0)

#define MMU_ADDRESS_STALL_OFFSET					(0x012C)

#define MMU_ADDRESS_STALL_ADDRESS_STALL_MASK				(0xFFFFFFFF)
#define MMU_ADDRESS_STALL_ADDRESS_STALL_SHIFT				(0)

#define MMU_TAG_STALL_OFFSET						(0x0130)

#define MMU_TAG_STALL_TAG_STALL_MASK					(0xFFFFFFFF)
#define MMU_TAG_STALL_TAG_STALL_SHIFT					(0)

#define MMU_PEAK_READ_OUTSTANDING_OFFSET				(0x0140)

#define MMU_PEAK_READ_OUTSTANDING_PEAK_TAG_OUTSTANDING_MASK		(0x000003FF)
#define MMU_PEAK_READ_OUTSTANDING_PEAK_TAG_OUTSTANDING_SHIFT		(0)

#define MMU_PEAK_READ_OUTSTANDING_PEAK_READ_LATENCY_MASK		(0xFFFF0000)
#define MMU_PEAK_READ_OUTSTANDING_PEAK_READ_LATENCY_SHIFT		(16)

#define MMU_AVERAGE_READ_LATENCY_OFFSET					(0x0144)

#define MMU_AVERAGE_READ_LATENCY_AVERAGE_READ_LATENCY_MASK		(0xFFFFFFFF)
#define MMU_AVERAGE_READ_LATENCY_AVERAGE_READ_LATENCY_SHIFT		(0)

#define MMU_STATISTICS_CONTROL_OFFSET					(0x0160)

#define MMU_STATISTICS_CONTROL_BANDWIDTH_STATS_INIT_MASK		(0x00000001)
#define MMU_STATISTICS_CONTROL_BANDWIDTH_STATS_INIT_SHIFT		(0)

#define MMU_STATISTICS_CONTROL_STALL_STATS_INIT_MASK			(0x00000002)
#define MMU_STATISTICS_CONTROL_STALL_STATS_INIT_SHIFT			(1)

#define MMU_STATISTICS_CONTROL_LATENCY_STATS_INIT_MASK			(0x00000004)
#define MMU_STATISTICS_CONTROL_LATENCY_STATS_INIT_SHIFT			(2)

#define MMU_MMU_VERSION_OFFSET						(0x01D0)

#define MMU_MMU_VERSION_MMU_MAJOR_REV_MASK				(0x00FF0000)
#define MMU_MMU_VERSION_MMU_MAJOR_REV_SHIFT				(16)

#define MMU_MMU_VERSION_MMU_MINOR_REV_MASK				(0x0000FF00)
#define MMU_MMU_VERSION_MMU_MINOR_REV_SHIFT				(8)

#define MMU_MMU_VERSION_MMU_MAINT_REV_MASK				(0x000000FF)
#define MMU_MMU_VERSION_MMU_MAINT_REV_SHIFT				(0)

#define MMU_BYTE_SIZE							(0x01D4)

#endif
