#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-lib
version:              1.8.1
visibility:           public
id:                   clash-lib-1.8.1-Bg0vTDMsIzt7oIuc0iXViK
key:                  clash-lib-1.8.1-Bg0vTDMsIzt7oIuc0iXViK
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2023, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  57cc6b00bfa77df2b2e1cb7e73458435
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Backend.Verilog.Time Clash.Core.DataCon
    Clash.Core.EqSolver Clash.Core.Evaluator.Types Clash.Core.FreeVars
    Clash.Core.HasFreeVars Clash.Core.HasType Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH Clash.Core.TyCon
    Clash.Core.Type Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var
    Clash.Core.VarEnv Clash.Data.UniqMap Clash.DataFiles Clash.Debug
    Clash.Driver Clash.Driver.Manifest Clash.Driver.Types
    Clash.Edalize.Edam Clash.Netlist Clash.Netlist.BlackBox
    Clash.Netlist.BlackBox.Parser Clash.Netlist.BlackBox.Types
    Clash.Netlist.BlackBox.Util Clash.Netlist.Expr Clash.Netlist.Id
    Clash.Netlist.Id.Common Clash.Netlist.Id.Internal
    Clash.Netlist.Id.SystemVerilog Clash.Netlist.Id.VHDL
    Clash.Netlist.Id.Verilog Clash.Netlist.Types Clash.Netlist.Util
    Clash.Normalize Clash.Normalize.PrimitiveReductions
    Clash.Normalize.Primitives Clash.Normalize.Strategy
    Clash.Normalize.Transformations Clash.Normalize.Transformations.ANF
    Clash.Normalize.Transformations.Case
    Clash.Normalize.Transformations.Cast
    Clash.Normalize.Transformations.DEC
    Clash.Normalize.Transformations.EtaExpand
    Clash.Normalize.Transformations.Inline
    Clash.Normalize.Transformations.Letrec
    Clash.Normalize.Transformations.MultiPrim
    Clash.Normalize.Transformations.Reduce
    Clash.Normalize.Transformations.SeparateArgs
    Clash.Normalize.Transformations.Specialize
    Clash.Normalize.Transformations.XOptimize Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty
    Clash.Primitives.Annotations.SynthesisAttributes
    Clash.Primitives.DSL Clash.Primitives.GHC.Int
    Clash.Primitives.GHC.Literal Clash.Primitives.GHC.Word
    Clash.Primitives.Intel.ClockGen Clash.Primitives.Magic
    Clash.Primitives.Sized.Signed Clash.Primitives.Sized.ToInteger
    Clash.Primitives.Sized.Vector Clash.Primitives.Types
    Clash.Primitives.Util Clash.Primitives.Verification
    Clash.Primitives.Xilinx.ClockGen Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Eq Clash.Util.Graph
    Clash.Util.Interpolate Clash.Verification.Pretty Data.Aeson.Extra
    Data.Text.Prettyprint.Doc.Extra GHC.BasicTypes.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Data.IntMap.Extra Data.List.Extra
    Data.Map.Ordered.Extra Data.Monoid.Extra
    Data.Primitive.ByteArray.Extra Data.Set.Ordered.Extra
    Data.Text.Extra GHC.SrcLoc.Extra Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.2.8/site-local/clash-lib-1.8.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/clash-lib-1.8.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-lib
hs-libraries:         HSclash-lib-1.8.1-Bg0vTDMsIzt7oIuc0iXViK
depends:
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    aeson-pretty-0.8.10-5TSYkD8Co5LLMI8e0zAoII
    ansi-terminal-0.11.5-GmxlGl1eC6rGTjWL8Yprft array-0.5.4.0
    async-2.2.5-A9yY3sStrUyIJcfOkNbDOv
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI
    attoparsec-aeson-2.1.0.0-KcE116pIeFF2MamckD5i3s base-4.16.4.0
    base16-bytestring-1.0.2.0-BfU7bG0tjnC37zYxX4slQA binary-0.8.9.0
    bytestring-0.11.4.0 clash-prelude-1.8.1-FVaprtogMECKZ7b472FtiD
    concurrent-supply-0.1.8-3OpYSG4Qjm74lJEyXmGJB7 containers-0.6.5.1
    cryptohash-sha256-0.11.102.1-IJPkgr8yXYZ3pOUoxE9WNg
    data-binary-ieee754-0.4.4-5RBO9sqtqwKK43ihLnlB61
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS deepseq-1.4.6.1
    directory-1.3.6.2 dlist-1.0-HCxoMn9TirQDgPCFxho7O exceptions-0.10.4
    extra-1.7.16-HmT1ExbMa8s7Fr43bhn74d filepath-1.4.2.2 ghc-9.2.8
    ghc-bignum-1.2 ghc-boot-th-9.2.8
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    haskell-src-meta-0.8.13-K82q3ORY4nEGdZM6mpdQHq
    hint-0.9.0.6-3cpIeNDt5rNIiy5nVqVNCS
    infinite-list-0.1.1-LDk3j8FUiCzBefsXuVulhJ
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7 mtl-2.2.2
    ordered-containers-0.2.4-9ENMyFnRxp1DgUrKzXC0KV
    pretty-show-1.10-JwphvxEdk99BsHrT870tUy
    prettyprinter-1.7.1-9qid7zuo3B05OoqIIBWgnL
    prettyprinter-interp-0.2.0.0-6rQxvZbdPq68CpLpx1R7F9
    primitive-0.7.4.0-1hjisjTIkm1Ju7TlHVggBl
    string-interpolate-0.3.4.0-5Ws3COJGwR537UBRNVUzaR
    template-haskell-2.18.0.0 temporary-1.3-6g6bzMzGEBECPR8ySppZs6
    terminal-size-0.3.4-7GJNKkuDjwr8c9rYP2Bu9E text-1.2.5.0
    time-1.11.1.1 transformers-0.5.6.2
    trifecta-2.1.4-Ev5wQLTgqalHvZpBHv5Eef
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN
    vector-binary-instances-0.2.5.2-2rPoeenurIpszt2PiMcoW
    yaml-0.11.11.2-FsesGw9U9gbF319C8E5TNI

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

