#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tidal
version:              1.9.5
visibility:           public
id:                   tidal-1.9.5-Knj7eSBGfa74sagh4aFfhc
key:                  tidal-1.9.5-Knj7eSBGfa74sagh4aFfhc
license:              GPL-3.0-only
copyright:            (c) Alex McLean and other contributors, 2021
maintainer:
    Alex McLean <alex@slab.org>, Mike Hodnick <mike.hodnick@gmail.com>

author:               Alex McLean
stability:            Experimental
homepage:             http://tidalcycles.org/
synopsis:             Pattern language for improvised music
description:
    Tidal is a domain specific language for live coding patterns.

category:             Sound
abi:                  7f441fb05e536ac9e92403fe81637cc4
exposed:              True
exposed-modules:
    Paths_tidal Sound.Tidal.Bjorklund Sound.Tidal.Chords
    Sound.Tidal.Config Sound.Tidal.Context Sound.Tidal.Control
    Sound.Tidal.Core Sound.Tidal.ID Sound.Tidal.Params
    Sound.Tidal.ParseBP Sound.Tidal.Pattern Sound.Tidal.Safe.Boot
    Sound.Tidal.Safe.Context Sound.Tidal.Scales Sound.Tidal.Show
    Sound.Tidal.Simple Sound.Tidal.Stream Sound.Tidal.StreamTypes
    Sound.Tidal.Tempo Sound.Tidal.Time Sound.Tidal.Transition
    Sound.Tidal.UI Sound.Tidal.Utils Sound.Tidal.Version

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tidal-1.9.5
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tidal-1.9.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tidal
hs-libraries:         HStidal-1.9.5-Knj7eSBGfa74sagh4aFfhc
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    clock-0.8.4-8gAYYIEtjnY1IfqjL0QYZj
    colour-2.3.6-KDhjTRIL7rnBhoKfQ21QbO containers-0.6.5.1
    deepseq-1.4.6.1 exceptions-0.10.4 hosc-0.20-6CTlBtNI6HHEEjLD3lNQCj
    mtl-2.2.2 network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs parsec-3.1.15.0
    primitive-0.7.4.0-1hjisjTIkm1Ju7TlHVggBl
    random-1.2.1.2-LilJ2o1ueBgJ3oDFJkkk0o text-1.2.5.0
    tidal-link-1.0.3-I5U1Wc4P3k4JeOMqGuGeth transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-tidal/html/tidal.haddock
haddock-html:         /usr/share/doc/haskell-tidal/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

