#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-term
version:              1.10.0
visibility:           public
id:                   tamarin-prover-term-1.10.0-ASJ3tROaItBKVYmkCtQtCX
key:                  tamarin-prover-term-1.10.0-ASJ3tROaItBKVYmkCtQtCX
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.

category:             Theorem Provers
abi:                  ae3f4aba99e37bab598038180c4585a0
exposed:              True
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Macro Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm

hidden-modules:
    Term.Term Term.Term.Classes Term.Term.Raw Term.Term.FunctionSymbols
    Term.Narrowing.Narrow Term.Substitution.SubstVFree
    Term.Substitution.SubstVFresh

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tamarin-prover-term-1.10.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tamarin-prover-term-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-term
hs-libraries:         HStamarin-prover-term-1.10.0-ASJ3tROaItBKVYmkCtQtCX
depends:
    HUnit-1.6.2.0-8V4cpd2vyM7I9OG8MrEdHy
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI base-4.16.4.0
    binary-0.8.9.0 bytestring-0.11.4.0 containers-0.6.5.1
    deepseq-1.4.6.1 dlist-1.0-HCxoMn9TirQDgPCFxho7O mtl-2.2.2
    process-1.6.16.0 safe-0.3.21-41ZPWazUMNgR08x0DBIts
    tamarin-prover-utils-1.10.0-9iuWEDNjyrm4QOFQNH0mjZ

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

