#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslua
version:              2.3.0
visibility:           public
id:                   hslua-2.3.0-CncCIeJ3095AKC0bxiPs3K
key:                  hslua-2.3.0-CncCIeJ3095AKC0bxiPs3K
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2023 Albert Krewinkel

maintainer:           tarleb@hslua.org
author:               Albert Krewinkel, Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.org/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides wrappers and helpers
    to bridge Haskell and <https://www.lua.org/ Lua>.

    It builds upon the /lua/ package, which allows to bundle
    a Lua interpreter with a Haskell program.

    Example programs are can be found in the @hslua-examples@
    subdir of the project
    <https://github.com/hslua/hslua repository>.

category:             Foreign
abi:                  f7c5cf87f11ae660e294d8dd19c3b915
exposed:              True
exposed-modules:
    HsLua,
    HsLua.Aeson from hslua-aeson-2.3.0.1-I6YwFK4rJDfBuwanKpKFrD:HsLua.Aeson,
    HsLua.Class.Exposable from hslua-classes-2.3.0-Bhs8Q19YqfTG1i3smTZxkf:HsLua.Class.Exposable,
    HsLua.Class.Invokable from hslua-classes-2.3.0-Bhs8Q19YqfTG1i3smTZxkf:HsLua.Class.Invokable,
    HsLua.Class.Peekable from hslua-classes-2.3.0-Bhs8Q19YqfTG1i3smTZxkf:HsLua.Class.Peekable,
    HsLua.Class.Pushable from hslua-classes-2.3.0-Bhs8Q19YqfTG1i3smTZxkf:HsLua.Class.Pushable,
    HsLua.Class.Util from hslua-classes-2.3.0-Bhs8Q19YqfTG1i3smTZxkf:HsLua.Class.Util,
    HsLua.Core from hslua-core-2.3.1-7tP5g9DQ4OeKdOyVI81TL5:HsLua.Core,
    HsLua.Core.Error from hslua-core-2.3.1-7tP5g9DQ4OeKdOyVI81TL5:HsLua.Core.Error,
    HsLua.Core.Types from hslua-core-2.3.1-7tP5g9DQ4OeKdOyVI81TL5:HsLua.Core.Types,
    HsLua.Core.Utf8 from hslua-core-2.3.1-7tP5g9DQ4OeKdOyVI81TL5:HsLua.Core.Utf8,
    HsLua.Marshalling from hslua-marshalling-2.3.1-JCueeqDsAl64rAvJDWOXcX:HsLua.Marshalling,
    HsLua.ObjectOrientation from hslua-objectorientation-2.3.0-BtVRFSELh916HNgMidkxDu:HsLua.ObjectOrientation,
    HsLua.Packaging from hslua-packaging-2.3.1-JrcVYaOwMi2LpAg5X3lhR2:HsLua.Packaging,
    HsLua.Packaging.Function from hslua-packaging-2.3.1-JrcVYaOwMi2LpAg5X3lhR2:HsLua.Packaging.Function,
    HsLua.Packaging.Module from hslua-packaging-2.3.1-JrcVYaOwMi2LpAg5X3lhR2:HsLua.Packaging.Module,
    HsLua.Packaging.Rendering from hslua-packaging-2.3.1-JrcVYaOwMi2LpAg5X3lhR2:HsLua.Packaging.Rendering,
    HsLua.Typing from hslua-typing-0.1.1-E78oz3WRBt26g1uab1iM6c:HsLua.Typing,
    HsLua.Util

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hslua-2.3.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hslua-2.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua
hs-libraries:         HShslua-2.3.0-CncCIeJ3095AKC0bxiPs3K
depends:
    base-4.16.4.0 bytestring-0.11.4.0 containers-0.6.5.1
    exceptions-0.10.4 hslua-aeson-2.3.0.1-I6YwFK4rJDfBuwanKpKFrD
    hslua-classes-2.3.0-Bhs8Q19YqfTG1i3smTZxkf
    hslua-core-2.3.1-7tP5g9DQ4OeKdOyVI81TL5
    hslua-marshalling-2.3.1-JCueeqDsAl64rAvJDWOXcX
    hslua-objectorientation-2.3.0-BtVRFSELh916HNgMidkxDu
    hslua-packaging-2.3.1-JrcVYaOwMi2LpAg5X3lhR2
    hslua-typing-0.1.1-E78oz3WRBt26g1uab1iM6c mtl-2.2.2 text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

