#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.41.2
visibility:           public
id:                   dhall-1.41.2-Kmkxrn5zFVuASJbeQVJgBi
key:                  dhall-1.41.2-Kmkxrn5zFVuASJbeQVJgBi
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  3b76f773a1409c853622971e9cb6c0f2
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Import.Headers
    Dhall.Marshal.Internal Dhall.Normalize Dhall.Parser.Combinators
    Dhall.Pretty.Internal Dhall.Syntax Dhall.URL Paths_dhall
    Dhall.Import.HTTP Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/dhall-1.41.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.41.2-Kmkxrn5zFVuASJbeQVJgBi
depends:
    Diff-0.4.1-7DJ54PO7amxJCKVFCJguu4
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    aeson-pretty-0.8.10-5TSYkD8Co5LLMI8e0zAoII
    ansi-terminal-0.11.5-GmxlGl1eC6rGTjWL8Yprft
    atomic-write-0.2.1.0-BPBkIok1qt67PUV6Cf1yJY base-4.16.4.0
    base16-bytestring-1.0.2.0-BfU7bG0tjnC37zYxX4slQA
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-3YsL0BQanAbLHEhUwcLo8j
    cborg-0.2.9.0-CjGynlrZPDH1DqXaqTGIcK
    cborg-json-0.2.5.0-2bOMyLtpm3vK5hcW8rIEsq containers-0.6.5.1
    contravariant-1.5.5-6oWUjmJNxDBFhugVD5s9dq
    cryptohash-sha256-0.11.102.1-IJPkgr8yXYZ3pOUoxE9WNg
    data-fix-0.3.2-FGkTCFWnE3E5Wykr5tvlhN deepseq-1.4.6.1
    directory-1.3.6.2 dotgen-0.4.3-GrGnAzxXk0NF0mUN2K7zar
    either-5.0.2-AtRiUEGr5OmtFhB2bWxlv exceptions-0.10.4
    filepath-1.4.2.2 half-0.3.1-LKt7slib8je94L7B8JIQZT
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj haskeline-0.8.2
    http-client-0.7.17-DzkkR0N3yiTIx1C6IcWQ7J
    http-client-tls-0.3.6.3-2EQqEGNQgqBeXR2SFRRfB
    http-types-0.12.4-6kOruwBLItLEcotK7uAwKL
    indexed-traversable-0.1.4-6hGnPWNuqXlFS0NzZXy7sq
    lens-family-core-2.1.3-1OBIJmYHsnQ2CJGGRserxu
    megaparsec-9.6.1-xFWwysPvLWIMfIZXM34tr
    mmorph-1.2.0-86rQZSuTSAZIoeBosVXsFi mtl-2.2.2
    network-uri-2.6.4.2-74JpbzeSIdyJoqu3FQVNpR
    optparse-applicative-0.17.1.0-G3d2ugE95DU3DYNCy08LZF
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5
    parsers-0.12.11-73EyaS5Do1M6EDsrRiNa8X
    pretty-simple-4.1.2.0-aemf95GDbcJZS8DJ9CNZc
    prettyprinter-1.7.1-9qid7zuo3B05OoqIIBWgnL
    prettyprinter-ansi-terminal-1.1.3-LWMhohC2bf65OdaY6HUJHG
    profunctors-5.6.2-INIM7Wdge0m5823pXp4AgG
    repline-0.4.2.0-8F4hfQj1tzA4brx66W1hS8
    scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI
    serialise-0.2.6.1-3Qt2J3LpivxJG0Dq3Sc2lF template-haskell-2.18.0.0
    text-1.2.5.0 text-manipulate-0.3.1.0-AdZFfANKJHw2OeZxzxwuID
    text-short-0.1.6-1LbBtFl8nZt2KELkxcBYvU
    th-lift-instances-0.1.20-LAQ9hvp3zHy4kfAKwrCSrK time-1.11.1.1
    transformers-0.5.6.2
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    uri-encode-1.5.0.7-AxIaf3k11Qf3jf5NnMKFHX
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

