/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.dameng.DamengConstants;
import org.jkiss.dbeaver.ext.dameng.model.DamengDataSource;
import org.jkiss.dbeaver.ext.dameng.model.DamengDataTypeCache;
import org.jkiss.dbeaver.ext.dameng.model.DamengSchema;
import org.jkiss.dbeaver.ext.dameng.model.DamengSequence;
import org.jkiss.dbeaver.ext.dameng.model.DamengTable;
import org.jkiss.dbeaver.ext.dameng.model.DamengTableColumn;
import org.jkiss.dbeaver.ext.dameng.model.DamengUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericContainerTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class DamengMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(DamengMetaModel.class);

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new DamengDataSource(monitor, container, this);
    }

    public JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> createDataTypeCache(@NotNull GenericStructContainer container) {
        return new DamengDataTypeCache(container);
    }

    public DamengSchema createSchemaImpl(@NotNull GenericDataSource dataSource, GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new DamengSchema(dataSource, schemaName, true);
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new GenericView(container, tableName, tableType, dbResult);
        }
        return new DamengTable(container, tableName, tableType, dbResult);
    }

    public GenericTableBase createTableImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericMetaObject tableObject, @NotNull JDBCResultSet dbResult) {
        return super.createTableImpl(session, owner, tableObject, dbResult);
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(JDBCSession session, GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT SEQ_OBJ.NAME, SEQ_OBJ.INFO4 AS INCREMENT, SF_SEQUENCE_GET_MAX(SCH_OBJ.NAME,SEQ_OBJ.NAME) AS MAX_VALUE,SF_SEQUENCE_GET_MIN(SCH_OBJ.NAME,SEQ_OBJ.NAME) AS MIN_VALUE,SF_SEQ_CURRVAL(SCH_OBJ.NAME,SEQ_OBJ.NAME) AS LAST_VALUE, SF_SEQUENCE_GET_CACHE_NUM(SCH_OBJ.NAME,SEQ_OBJ.NAME) CACHE_SIZE,SEQ_OBJ.INFO1 & 0x0000FF IS_CYCLE,SEQ_OBJ.INFO1 & 0x00FF00 IS_ORDER,SEQ_OBJ.INFO1 & 0xFF0000 IS_CACHE\nFROM SYSOBJECTS SEQ_OBJ, SYSOBJECTS SCH_OBJ \nWHERE SEQ_OBJ.SCHID = SCH_OBJ.ID AND SEQ_OBJ.SUBTYPE$ = 'SEQ' AND SCH_OBJ.NAME = ?");
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        long lastValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"LAST_VALUE");
        long incrementBy = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INCREMENT");
        long minValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MIN_VALUE");
        long maxValue = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_VALUE");
        return new DamengSequence(container, name, null, lastValue, minValue, maxValue, incrementBy, dbResult);
    }

    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareTableTriggersLoadStatement(JDBCSession session, @NotNull GenericStructContainer container, GenericTableBase table) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABTRIG_OBJ_INNER.NAME AS TRIGGER_NAME, TAB_OBJ_INNER.NAME AS OWNER,* FROM SYSOBJECTS TABTRIG_OBJ_INNER, SYSOBJECTS TAB_OBJ_INNER WHERE TABTRIG_OBJ_INNER.SUBTYPE$ = 'TRIG' AND TABTRIG_OBJ_INNER.PID = TAB_OBJ_INNER.ID " + (table != null ? "AND TAB_OBJ_INNER.NAME= ? " : ""));
        if (table != null) {
            dbStat.setString(1, table.getName());
        }
        return dbStat;
    }

    public GenericTrigger createTableTriggerImpl(JDBCSession session, GenericStructContainer genericStructContainer, GenericTableBase genericTableBase, String triggerName, JDBCResultSet resultSet) throws DBException {
        if (CommonUtils.isEmpty((String)triggerName)) {
            triggerName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TRIGGER_NAME");
        }
        return new GenericTableTrigger(genericTableBase, triggerName, null);
    }

    public JDBCStatement prepareContainerTriggersLoadStatement(JDBCSession session, GenericStructContainer forParent) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABTRIG_OBJ_INNER.NAME FROM SYSOBJECTS TABTRIG_OBJ_INNER, SYSOBJECTS SCH_OBJ_INNER WHERE TABTRIG_OBJ_INNER.SUBTYPE$ = 'TRIG' AND TABTRIG_OBJ_INNER.PID = SCH_OBJ_INNER.ID AND SCH_OBJ_INNER.NAME = ?");
        dbStat.setString(1, forParent.getName());
        return dbStat;
    }

    public GenericTrigger createContainerTriggerImpl(GenericStructContainer container, JDBCResultSet resultSet) throws DBException {
        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"NAME");
        if (name == null) {
            return null;
        }
        return new GenericContainerTrigger(container, name, null);
    }

    public String getTriggerDDL(DBRProgressMonitor monitor, GenericTrigger sourceObject) throws DBException {
        if (sourceObject.getContainer() instanceof DamengTable) {
            return DamengUtils.getDDL(monitor, (DBSObject)sourceObject, DamengConstants.ObjectType.TRIGGER, ((GenericStructContainer)((DamengTable)sourceObject.getContainer()).getContainer()).getName());
        }
        return DamengUtils.getDDL(monitor, (DBSObject)sourceObject, DamengConstants.ObjectType.TRIGGER, sourceObject.getContainer().getName());
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return DamengUtils.getDDL(monitor, (DBSObject)sourceObject, DamengConstants.ObjectType.VIEW, sourceObject.getParentObject().getName());
    }

    public DamengTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new DamengTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    /*
     * Loose catch block
     */
    public List<? extends GenericTrigger> loadTriggers(DBRProgressMonitor monitor, GenericStructContainer container, GenericTableBase table) throws DBException {
        if (table == null) {
            return Collections.emptyList();
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<GenericTableTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block33: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbStat = session.prepareStatement("SELECT TABTRIG_OBJ_INNER.NAME FROM SYSOBJECTS TABTRIG_OBJ_INNER, SYSOBJECTS SCH_OBJ_INNER WHERE TABTRIG_OBJ_INNER.SUBTYPE$ = 'TRIG' AND TABTRIG_OBJ_INNER.SCHID = SCH_OBJ_INNER.ID AND SCH_OBJ_INNER.NAME = ? AND TABTRIG_OBJ_INNER.NAME = ?");
                    dbStat.setString(1, table.getSchema().getName());
                    dbStat.setString(2, table.getName());
                    ArrayList<GenericTableTrigger> result = new ArrayList<GenericTableTrigger>();
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            result.add(new GenericTableTrigger(table, name, null));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block33;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        GenericDataSource dataSource = container.getDataSource();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read Dameng procedure source");){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT\nPROC_OBJ.ID,\nPROC_OBJ.NAME,\nPROC_OBJ.CRTDATE,\nPROC_OBJ.INFO1,\nPROC_OBJ.VALID\nFROM\nSYSOBJECTS PROC_OBJ,\nSYSOBJECTS SCH_OBJ,\nSYSOBJECTS USER_OBJ\nWHERE\nPROC_OBJ.SCHID = SCH_OBJ.ID\nAND SCH_OBJ.PID = USER_OBJ.ID\nAND PROC_OBJ.SUBTYPE$ = 'PROC'\nAND SF_CHECK_PRIV_OPT(UID(),\nCURRENT_USERTYPE(),\nPROC_OBJ.ID,\nUSER_OBJ.ID,\nUSER_OBJ.INFO1,\nPROC_OBJ.ID) = 1\nAND SCH_OBJ.NAME = ? ");){
                    dbStat.setString(1, container.getName());
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.nextRow()) {
                            DBSProcedureType routineType = DBSProcedureType.PROCEDURE;
                            try {
                                int type = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"INFO1");
                                routineType = switch (type) {
                                    case 1 -> DBSProcedureType.PROCEDURE;
                                    case 0 -> DBSProcedureType.FUNCTION;
                                    default -> routineType;
                                };
                            }
                            catch (IllegalArgumentException e) {
                                log.warn((Object)e);
                            }
                            GenericProcedure procedure = this.createProcedureImpl((GenericStructContainer)container, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME"), null, routineType, null);
                            container.addProcedure(procedure);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)dataSource);
        }
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        DBSProcedureType procedureType = sourceObject.getProcedureType();
        DamengConstants.ObjectType objectType = switch (procedureType) {
            case DBSProcedureType.PROCEDURE -> DamengConstants.ObjectType.PROCEDURE;
            case DBSProcedureType.FUNCTION -> DamengConstants.ObjectType.FUNCTION;
            case DBSProcedureType.UNKNOWN -> null;
            default -> throw new IncompatibleClassChangeError();
        };
        return DamengUtils.getDDL(monitor, (DBSObject)sourceObject, objectType, ((GenericStructContainer)sourceObject.getContainer()).getName());
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        return "AUTO_INCREMENT";
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public boolean isTableColumnCommentEditable() {
        return true;
    }

    public boolean isColumnNotNullByDefault() {
        return true;
    }
}

