/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeLoadService;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeLoadVisualizer;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeFilterConfigurator;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeLazyExpander;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

public class DatabaseNavigatorContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private static final Log log = Log.getLog(DatabaseNavigatorContentProvider.class);
    private static final Object[] EMPTY_CHILDREN = new Object[0];
    private DatabaseNavigatorTree navigatorTree;
    private boolean showRoot;

    public DatabaseNavigatorContentProvider(DatabaseNavigatorTree navigatorTree, boolean showRoot) {
        this.navigatorTree = navigatorTree;
        this.showRoot = showRoot;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof DatabaseNavigatorContent) {
            DBNNode rootNode = ((DatabaseNavigatorContent)parent).getRootNode();
            if (rootNode == null) {
                return EMPTY_CHILDREN;
            }
            if (this.showRoot) {
                return new Object[]{rootNode};
            }
            return this.getChildren(rootNode);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof DBNLocalFolder) {
            DBNLocalFolder node = (DBNLocalFolder)child;
            return node.getLogicalParent();
        }
        if (child instanceof DBNNode) {
            DBNNode node = (DBNNode)child;
            return node.getParentNode();
        }
        if (child instanceof TreeNodeSpecial) {
            TreeNodeSpecial node = (TreeNodeSpecial)child;
            return node.getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeNodeSpecial) {
            return EMPTY_CHILDREN;
        }
        if (!(parent instanceof DBNNode)) {
            return EMPTY_CHILDREN;
        }
        DBNNode parentNode = (DBNNode)parent;
        if (!parentNode.hasChildren(true)) {
            return EMPTY_CHILDREN;
        }
        if (parentNode instanceof DBNLazyNode && ((DBNLazyNode)parentNode).needsInitialization()) {
            return TreeLoadVisualizer.expandChildren((AbstractTreeViewer)this.navigatorTree.getViewer(), new TreeLoadService("Loading", parentNode));
        }
        try {
            Throwable lastLoadError;
            DBNNode[] children = DBNUtils.getNodeChildrenFiltered((DBRProgressMonitor)new VoidProgressMonitor(), (DBNNode)parentNode, (boolean)true);
            if (children == null && (lastLoadError = parentNode.getLastLoadError()) != null) {
                UIUtils.asyncExec(() -> DBWorkbench.getPlatformUI().showError("Error during node load", CommonUtils.notEmpty((String)lastLoadError.getMessage()), lastLoadError));
            }
            return DatabaseNavigatorContentProvider.getFinalNodes(parentNode, children);
        }
        catch (Throwable ex) {
            UIUtils.asyncExec(() -> {
                DBWorkbench.getPlatformUI().showError("Navigator error", ex.getMessage(), ex);
                this.navigatorTree.getViewer().collapseToLevel(parent, 1);
            });
            return EMPTY_CHILDREN;
        }
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof DBNDatabaseNode) {
            if (this.navigatorTree.getNavigatorFilter() != null && this.navigatorTree.getNavigatorFilter().isLeafObject(parent)) {
                return false;
            }
            if (((DBNDatabaseNode)parent).getDataSourceContainer().getNavigatorSettings().isShowOnlyEntities() && ((DBNDatabaseNode)parent).getObject() instanceof DBSEntity) {
                return false;
            }
        }
        return parent instanceof DBNNode && ((DBNNode)parent).hasChildren(true);
    }

    @NotNull
    private static Object[] getFinalNodes(@NotNull DBNNode parent, @NotNull DBNNode[] children) {
        int maxFetchSize = Math.max(100, DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.long.list.fetch.size"));
        if (parent.isFiltered() || maxFetchSize < children.length) {
            ArrayList<TreeNodeSpecial> nodes = new ArrayList<TreeNodeSpecial>(maxFetchSize);
            if (parent.isFiltered()) {
                nodes.add(new TreeNodeFilterConfigurator(parent));
            }
            if (maxFetchSize < children.length) {
                nodes.addAll(List.of(children).subList(0, maxFetchSize));
                nodes.add(new TreeNodeLazyExpander(parent, children, maxFetchSize));
            } else {
                nodes.addAll(List.of(children));
            }
            return nodes.toArray();
        }
        if (children.length == 0) {
            return EMPTY_CHILDREN;
        }
        return children;
    }
}

