/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.ui.editors.NodeEditorInputFactory;

public class NodeEditorInput
implements INavigatorEditorInput,
IPersistableElement {
    private volatile DBNNode node;
    private String nodePath;

    public NodeEditorInput(DBNNode node) {
        this.node = node;
    }

    public NodeEditorInput(String nodePath) {
        this.nodePath = nodePath;
    }

    @Override
    public DBNNode getNavigatorNode() {
        if (this.node == null) {
            if (this.nodePath == null) {
                throw new IllegalStateException("Invalid node input");
            }
            try {
                DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
                this.node = navigatorModel.getNodeByPath((DBRProgressMonitor)new VoidProgressMonitor(), this.nodePath);
                if (this.node == null) {
                    throw new IllegalStateException("Navigator node '" + this.nodePath + "' not found");
                }
            }
            catch (DBException e) {
                throw new IllegalStateException("Cannot find navigator node '" + this.nodePath + "'", e);
            }
        }
        return this.node;
    }

    public void setNavigatorNode(DBNNode node) {
        this.node = node;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)this.getNavigatorNode().getNodeIcon());
    }

    public String getName() {
        return this.node == null ? this.nodePath : this.node.getNodeDisplayName();
    }

    public IPersistableElement getPersistable() {
        return this.node == null || this.node.isDisposed() || !this.node.isPersisted() ? null : this;
    }

    public String getToolTipText() {
        return this.node == null ? null : this.node.getNodeDescription();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBNNode.class) {
            return adapter.cast(this.getNavigatorNode());
        }
        return null;
    }

    public String getFactoryId() {
        return NodeEditorInputFactory.ID_FACTORY;
    }

    public void saveState(IMemento memento) {
        if (this.node == null || this.node.isDisposed() || !this.node.isPersisted()) {
            return;
        }
        NodeEditorInputFactory.saveState(memento, this);
    }
}

