/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.IViewDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskFolderEvent;
import org.jkiss.dbeaver.model.task.DBTTaskListener;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.TaskFeatures;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIViewMessages;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksTree;
import org.jkiss.dbeaver.tasks.ui.view.TaskHandlerGroupBy;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ClipboardData;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ILabelProviderEx;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseTasksView
extends ViewPart
implements DBTTaskListener {
    private static final Log log = Log.getLog(DatabaseTasksView.class);
    public static final String VIEW_ID = "org.jkiss.dbeaver.tasks";
    private static final String TASKS_VIEW_MENU_ID = "org.jkiss.dbeaver.tasks.menu";
    private static final String TASK_RUNS_MENU_ID = "org.jkiss.dbeaver.tasks.runs.menu";
    public static final String CREATE_TASK_CMD_ID = "org.jkiss.dbeaver.task.create";
    public static final String COPY_TASK_CMD_ID = "org.jkiss.dbeaver.task.copy";
    public static final String EDIT_TASK_CMD_ID = "org.jkiss.dbeaver.task.edit";
    public static final String RUN_TASK_CMD_ID = "org.jkiss.dbeaver.task.run";
    private static final String CREATE_FOLDER_TASK_CMD_ID = "org.jkiss.dbeaver.folder.task.create";
    private static final String CREATE_FOLDER_RENAME_CMD_ID = "org.jkiss.dbeaver.folder.rename";
    public static final String GROUP_TASK_CMD_ID = "org.jkiss.dbeaver.task.group";
    private static final ArrayList<Object> EMPTY_TASK_RUN_LIST = new ArrayList();
    private DatabaseTasksTree tasksTree;
    private TreeViewer taskRunViewer;
    private ViewerColumnController<?, ?> taskRunColumnController;
    private DBPProjectListener projectListener;
    private transient DBTTask currentTask;

    @Nullable
    public DatabaseTasksTree getTasksTree() {
        return this.tasksTree;
    }

    public TreeViewer getTaskRunViewer() {
        return this.taskRunViewer;
    }

    public void createPartControl(Composite parent) {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer")) {
            log.debug((Object)"The user needs more permissions to see the Database Tasks View.");
            return;
        }
        CustomSashForm sashForm = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)256);
        this.createTaskTree((Composite)sashForm);
        this.createTaskRunTable((Composite)sashForm);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tasksTree.getViewer());
        sashForm.setWeights(new int[]{700, 300});
        this.loadViewConfig();
        this.loadTasks();
        this.updateViewTitle();
        this.projectListener = new DBPProjectListener(){

            public void handleActiveProjectChange(@NotNull DBPProject oldValue, @NotNull DBPProject newValue) {
                DatabaseTasksView.this.refresh();
            }
        };
        DBPPlatformDesktop.getInstance().getWorkspace().addProjectListener(this.projectListener);
        TaskFeatures.TASKS_VIEW_OPEN.use();
    }

    private void createTaskTree(Composite composite) {
        this.tasksTree = new DatabaseTasksTree(composite, false);
        MenuManager menuMgr = this.createTaskContextMenu(this.tasksTree.getViewer());
        this.getSite().registerContextMenu(TASKS_VIEW_MENU_ID, menuMgr, (ISelectionProvider)this.tasksTree.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tasksTree.getViewer());
        this.tasksTree.getViewer().addDoubleClickListener(event -> {
            if (ActionUtils.isCommandEnabled((String)EDIT_TASK_CMD_ID, (IServiceLocator)this.getSite())) {
                ActionUtils.runCommand((String)EDIT_TASK_CMD_ID, (ISelection)this.getSite().getSelectionProvider().getSelection(), (IServiceLocator)this.getSite());
            }
        });
        this.tasksTree.getViewer().addSelectionChangedListener(event -> this.loadTaskRuns(false));
        DatabaseTasksTree.addDragAndDropSourceSupport((Viewer)this.tasksTree.getViewer());
    }

    private void createTaskRunTable(Composite parent) {
        this.taskRunViewer = DialogUtils.createFilteredTree((Composite)parent, (int)65540, (PatternFilter)new NamedObjectPatternFilter(), (String)TaskUIViewMessages.db_tasks_view_filtered_tree_text_error_message);
        Tree taskrunTree = this.taskRunViewer.getTree();
        taskrunTree.setHeaderVisible(true);
        taskrunTree.setLayoutData((Object)new GridData(1808));
        this.taskRunColumnController = new ViewerColumnController("taskruns", (ColumnViewer)this.taskRunViewer);
        this.taskRunColumnController.addColumn(TaskUIViewMessages.db_tasks_view_column_controller_add_name_time, TaskUIViewMessages.db_tasks_view_column_controller_add_descr_start_time, 16384, true, true, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(tasksTree.getDateFormat().format(taskRun.getStartTime()));
            }
        });
        this.taskRunColumnController.addColumn(TaskUIViewMessages.db_tasks_view_column_controller_add_name_duration, TaskUIViewMessages.db_tasks_view_column_controller_add_descr_task_duration, 16384, true, false, true, null, (CellLabelProvider)new TaskRunLabelProviderEx(this){

            public String getText(Object element, boolean forUI) {
                DBTTaskRun taskRun = (DBTTaskRun)element;
                return !taskRun.isFinished() ? "N/A" : (forUI ? RuntimeUtils.formatExecutionTime((long)taskRun.getRunDuration()) : String.valueOf(taskRun.getRunDuration()));
            }

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(!taskRun.isFinished() ? "N/A" : RuntimeUtils.formatExecutionTime((long)taskRun.getRunDuration()));
            }
        }, null);
        this.taskRunColumnController.addColumn(TaskUIViewMessages.db_tasks_view_column_controller_add_name_result, TaskUIViewMessages.db_tasks_view_column_controller_add_descr_task_result, 16384, true, false, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                Object resultMessage = taskRun.isFinished() ? (taskRun.isRunSuccess() ? TaskUIViewMessages.db_tasks_view_cell_text_success : CommonUtils.notEmpty((String)taskRun.getErrorMessage())) : "In progress";
                String extraMessage = taskRun.getExtraMessage();
                if (CommonUtils.isNotEmpty((String)extraMessage)) {
                    resultMessage = (String)resultMessage + " (" + extraMessage + ")";
                }
                cell.setText((String)resultMessage);
            }
        });
        this.taskRunColumnController.setForceAutoSize(true);
        this.taskRunColumnController.createColumns(true);
        this.taskRunViewer.setContentProvider((IContentProvider)new TreeRunContentProvider());
        MenuManager menuMgr = this.createTaskRunContextMenu(this.taskRunViewer);
        this.getSite().registerContextMenu(TASK_RUNS_MENU_ID, menuMgr, (ISelectionProvider)this.taskRunViewer);
        this.taskRunViewer.addDoubleClickListener(event -> new ViewRunLogAction().run());
    }

    private MenuManager createTaskContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager(null, TASKS_VIEW_MENU_ID);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            boolean isVisible = true;
            DBTTask selectedTask = this.tasksTree.getSelectedTask();
            if (selectedTask != null) {
                isVisible = selectedTask.getProject().hasRealmPermission("project-datasource-edit");
            }
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)RUN_TASK_CMD_ID));
            if (isVisible) {
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)EDIT_TASK_CMD_ID));
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)CREATE_TASK_CMD_ID));
            }
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)COPY_TASK_CMD_ID));
            if (isVisible) {
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.eclipse.ui.edit.delete", (String)TaskUIViewMessages.db_tasks_view_context_menu_command_delete_task, null));
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)CREATE_FOLDER_TASK_CMD_ID));
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)CREATE_FOLDER_RENAME_CMD_ID));
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            TaskHandlerGroupBy.GroupBy[] groupByArray = TaskHandlerGroupBy.GroupBy.values();
            int n = groupByArray.length;
            int n2 = 0;
            while (n2 < n) {
                TaskHandlerGroupBy.GroupBy gb = groupByArray[n2];
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)GROUP_TASK_CMD_ID, (int)32, null, null, null, (boolean)true, Collections.singletonMap("group", gb.name())));
                ++n2;
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(WorkbenchMessages.Workbench_copy){

                public void run() {
                    ClipboardData clipboardData = new ClipboardData();
                    StringBuilder buf = new StringBuilder();
                    DatabaseTasksTree tasksTree = DatabaseTasksView.this.getTasksTree();
                    if (tasksTree == null) {
                        return;
                    }
                    TreeItem[] treeItemArray = tasksTree.getViewer().getTree().getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (buf.length() > 0) {
                            buf.append(GeneralUtils.getDefaultLineSeparator());
                        }
                        buf.append(item.getText(0));
                        ++n2;
                    }
                    clipboardData.addTransfer((Transfer)TextTransfer.getInstance(), (Object)buf.toString());
                    clipboardData.pushToClipboard(tasksTree.getViewer().getTree().getDisplay());
                }
            });
            manager.add((IContributionItem)new Separator());
            this.tasksTree.getColumnController().fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    private MenuManager createTaskRunContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager(null, TASK_RUNS_MENU_ID);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            manager.add((IContributionItem)new GroupMarker("start"));
            DBTTask task = this.tasksTree.getSelectedTask();
            DBTTaskRun taskRun = this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                manager.add((IAction)new ViewRunLogAction());
                manager.add((IAction)new DeleteRunLogAction());
            }
            if (task != null && task.getLastRun() != null) {
                manager.add((IAction)new ClearRunLogAction());
                manager.add((IAction)new OpenRunLogFolderAction());
            }
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            this.taskRunColumnController.fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    public void setFocus() {
        if (this.tasksTree == null) {
            return;
        }
        this.tasksTree.getViewer().getControl().setFocus();
    }

    @Nullable
    private DBTTaskRun getSelectedTaskRun() {
        ISelection selection = this.taskRunViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return element instanceof DBTTaskRun ? (DBTTaskRun)element : null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return TaskUIViewMessages.db_tasks_view_adapter_label_database_tasks;
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        TaskRegistry.getInstance().addTaskListener((DBTTaskListener)this);
    }

    public void dispose() {
        DBPPlatformDesktop.getInstance().getWorkspace().removeProjectListener(this.projectListener);
        TaskRegistry.getInstance().removeTaskListener((DBTTaskListener)this);
        super.dispose();
    }

    public void handleTaskEvent(DBTTaskEvent event) {
        UIUtils.asyncExec(() -> {
            DBTTask task = event.getTask();
            switch (event.getAction()) {
                case TASK_ADD: {
                    this.refresh();
                    this.tasksTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)task), true);
                    break;
                }
                case TASK_REMOVE: {
                    this.refresh();
                    break;
                }
                case TASK_UPDATE: {
                    this.tasksTree.getViewer().refresh((Object)task);
                    if (task != this.tasksTree.getSelectedTask()) break;
                    this.loadTaskRuns(true);
                    break;
                }
                case TASK_EXECUTE: {
                    this.refresh();
                }
            }
        });
    }

    public void handleTaskFolderEvent(DBTTaskFolderEvent event) {
        UIUtils.asyncExec(() -> {
            DBTTaskFolder taskFolder = event.getTaskFolder();
            switch (event.getAction()) {
                case TASK_FOLDER_ADD: {
                    this.refresh();
                    this.tasksTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)taskFolder), true);
                    break;
                }
                case TASK_FOLDER_UPDATE: {
                    this.tasksTree.getViewer().refresh((Object)taskFolder);
                    break;
                }
                case TASK_FOLDER_REMOVE: {
                    this.refresh();
                }
            }
        });
    }

    private void loadViewConfig() {
        if (this.tasksTree == null) {
            return;
        }
        this.tasksTree.loadViewConfig();
    }

    public void refresh() {
        this.updateViewTitle();
        if (this.tasksTree != null) {
            this.tasksTree.refresh();
        }
        this.loadTaskRuns(true);
    }

    private void updateViewTitle() {
        IViewDescriptor viewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(VIEW_ID);
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        this.setPartName(Objects.requireNonNull(viewDescriptor == null ? null : viewDescriptor.getLabel(), "") + " - " + Objects.requireNonNull(activeProject == null ? null : activeProject.getName(), ""));
    }

    private void loadTasks() {
        if (this.tasksTree == null) {
            return;
        }
        this.tasksTree.loadTasks();
    }

    private void loadTaskRuns(boolean force) {
        if (this.tasksTree == null) {
            return;
        }
        DBTTask selectedTask = this.tasksTree.getSelectedTask();
        if (!force && selectedTask == this.currentTask) {
            return;
        }
        this.currentTask = selectedTask;
        if (selectedTask == null) {
            this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
        } else {
            selectedTask.refreshRunStatistics();
            Object[] runs = selectedTask.getAllRuns();
            if (ArrayUtils.isEmpty((Object[])runs)) {
                this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
            } else {
                Arrays.sort(runs, Comparator.comparing(DBTTaskRun::getStartTime).reversed());
                this.taskRunViewer.setInput(Arrays.asList(runs));
            }
        }
    }

    private class ClearRunLogAction
    extends Action {
        ClearRunLogAction() {
            super(TaskUIViewMessages.db_tasks_view_clear_run_log_clear, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ERASE));
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            if (task == null || !UIUtils.confirmAction((String)TaskUIViewMessages.db_tasks_view_clear_run_log_confirm_clear, (String)NLS.bind((String)TaskUIViewMessages.db_tasks_view_clear_run_log_confirm_delete_log, (Object)task.getName()))) {
                return;
            }
            task.cleanRunStatistics();
        }
    }

    private class DeleteRunLogAction
    extends Action {
        DeleteRunLogAction() {
            super(TaskUIViewMessages.db_tasks_view_run_log_delete, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE));
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            DBTTaskRun taskRun = DatabaseTasksView.this.getSelectedTaskRun();
            if (task != null && taskRun != null && UIUtils.confirmAction((String)TaskUIViewMessages.db_tasks_view_run_log_confirm_remove, (String)NLS.bind((String)TaskUIViewMessages.db_tasks_view_run_log_confirm_delete_task, (Object)task.getName(), (Object)DatabaseTasksView.this.tasksTree.getDateFormat().format(taskRun.getStartTime())))) {
                task.removeRun(taskRun);
            }
        }
    }

    public static class NamedObjectPatternFilter
    extends PatternFilter {
        NamedObjectPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DBTTask) {
                return this.wordMatches(((DBTTask)element).getName());
            }
            if (element instanceof DBTTaskRun) {
                return this.wordMatches(element.toString());
            }
            return true;
        }
    }

    private class OpenRunLogFolderAction
    extends Action {
        OpenRunLogFolderAction() {
            super(TaskUIViewMessages.db_tasks_view_open_run_log_folder_open);
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            if (task != null) {
                Path path = task.getProject().getTaskManager().getStatisticsFolder(task);
                DBWorkbench.getPlatformUI().executeShellProgram(path.toAbsolutePath().toString());
            }
        }
    }

    private static class TaskCategoryNode {
        final DBPProject project;
        final TaskCategoryNode parent;
        final DBTTaskCategory category;

        TaskCategoryNode(DBPProject project, TaskCategoryNode parent, DBTTaskCategory category) {
            this.project = project;
            this.parent = parent;
            this.category = category;
        }

        public String toString() {
            return this.category.getName();
        }

        public int hashCode() {
            return (this.project == null ? 0 : this.project.hashCode()) + (this.parent == null ? 0 : this.parent.hashCode()) + (this.category == null ? 0 : this.category.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskCategoryNode)) {
                return false;
            }
            TaskCategoryNode cmp = (TaskCategoryNode)obj;
            return this.project == cmp.project && CommonUtils.equalObjects((Object)this.parent, (Object)cmp.parent) && this.category == cmp.category;
        }
    }

    private abstract class TaskRunLabelProvider
    extends ColumnLabelProvider {
        private TaskRunLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            DBTTaskRun taskRun = (DBTTaskRun)cell.getElement();
            if (taskRun != null && !taskRun.isRunSuccess()) {
                cell.setBackground(DatabaseTasksView.this.tasksTree.getColorError());
            } else {
                cell.setBackground(null);
            }
            this.update(cell, taskRun);
        }

        protected abstract void update(ViewerCell var1, DBTTaskRun var2);
    }

    private abstract class TaskRunLabelProviderEx
    extends TaskRunLabelProvider
    implements ILabelProviderEx {
        private TaskRunLabelProviderEx() {
        }
    }

    private static class TreeRunContentProvider
    implements ITreeContentProvider {
        private TreeRunContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class ViewRunLogAction
    extends Action {
        ViewRunLogAction() {
            super(TaskUIViewMessages.db_tasks_view_run_log_view);
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            DBTTaskRun taskRun = DatabaseTasksView.this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                Path runLog = task.getRunLog(taskRun);
                if (runLog == null) {
                    try {
                        runLog = this.receiveLogFile(task, taskRun);
                    }
                    catch (InvocationTargetException e) {
                        DBWorkbench.getPlatformUI().showError("Open log error", "Error while retrieving task run log", e.getCause());
                        return;
                    }
                }
                if (Files.exists(runLog, new LinkOption[0])) {
                    try {
                        IDocumentProvider prov;
                        IEditorPart editorPart = EditorUtils.openExternalFileEditor((File)runLog.toFile(), (IWorkbenchWindow)DatabaseTasksView.this.getSite().getWorkbenchWindow());
                        if (editorPart instanceof ITextEditor && (prov = ((ITextEditor)editorPart).getDocumentProvider()) instanceof TextFileDocumentProvider) {
                            ((TextFileDocumentProvider)prov).setEncoding((Object)editorPart.getEditorInput(), StandardCharsets.UTF_8.name());
                            prov.resetDocument((Object)editorPart.getEditorInput());
                        }
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Open log error", "Error while opening task execution log", (Throwable)e);
                    }
                } else {
                    UIUtils.showMessageBox((Shell)DatabaseTasksView.this.getSite().getShell(), (String)"Log file not found", (String)("Can't find log file '" + String.valueOf(runLog.toAbsolutePath()) + "'"), (int)1);
                }
            }
        }

        @NotNull
        private Path receiveLogFile(@NotNull DBTTask task, @NotNull DBTTaskRun run) throws InvocationTargetException {
            Path[] path = new Path[1];
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    monitor.beginTask("Retrieve task run log contents", 1);
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (InputStream is = task.getRunLogInputStream(run);){
                            Path folder = DBWorkbench.getPlatform().getTempFolder(monitor, "task-runs");
                            Path file = folder.resolve(run.getId() + ".txt");
                            Files.copy(is, file, StandardCopyOption.REPLACE_EXISTING);
                            pathArray[0] = file;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
            return Objects.requireNonNull(path[0]);
        }
    }
}

