/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.postgresql.model.session.PostgreSession;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;

public class PostgreSessionEditor
extends AbstractSessionEditor {
    private KillSessionAction terminateQueryAction;

    public void createEditorControl(Composite parent) {
        this.terminateQueryAction = new KillSessionAction();
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        DBAServerSessionManager sessionManager = (DBAServerSessionManager)DBUtils.getAdapter(DBAServerSessionManager.class, (Object)executionContext.getDataSource());
        return new SessionManagerViewer<PostgreSession>((IWorkbenchPart)this, parent, sessionManager){

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)PostgreSessionEditor.this.terminateQueryAction);
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                PostgreSessionEditor.this.terminateQueryAction.setEnabled(session != null);
            }
        };
    }

    private class KillSessionAction
    extends Action {
        KillSessionAction() {
            super("Terminate", UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP"));
        }

        public void run() {
            List sessions = PostgreSessionEditor.this.getSessionsViewer().getSelectedSessions();
            if (sessions != null && UIUtils.confirmAction((Shell)PostgreSessionEditor.this.getSite().getShell(), (String)this.getText(), (String)NLS.bind((String)"Terminate session {0}?", (Object)sessions))) {
                PostgreSessionEditor.this.getSessionsViewer().alterSessions(sessions, null);
            }
        }
    }
}

