/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridPrivilage;
import org.jkiss.dbeaver.ext.cubrid.ui.config.CubridPrivilageHandler;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class CubridUserManager
extends SQLObjectEditor<CubridPrivilage, GenericStructContainer> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, CubridPrivilage> getObjectsCache(CubridPrivilage object) {
        CubridDataSource parentObject = object.getParentObject();
        if (parentObject instanceof CubridDataSource) {
            CubridDataSource container = parentObject;
            return container.getDataSource().getCubridPrivilageCache();
        }
        return null;
    }

    protected CubridPrivilage createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @NotNull Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) {
        CubridPrivilage user = new CubridPrivilage((CubridDataSource)container, "NEW_USER", null);
        return user;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        CubridPrivilage user = (CubridPrivilage)command.getObject();
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE USER ");
        builder.append(this.getUserName(user, command.getProperties()));
        this.buildBody(user, builder, command.getProperties());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create User", builder.toString()));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        StringBuilder builder = new StringBuilder();
        builder.append("DROP USER ");
        builder.append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop User", builder.toString()));
    }

    private void buildBody(CubridPrivilage user, StringBuilder builder, Map<Object, Object> properties) {
        Object password = properties.get("PASSWORD");
        Object description = properties.get("DESCRIPTION");
        Object group = properties.get("GROUPS");
        if (password != null && CommonUtils.isNotEmpty((String)password.toString())) {
            builder.append(" PASSWORD ");
            builder.append(SQLUtils.quoteString((DBSObject)user, (String)password.toString()));
        }
        if (group != null && !CommonUtils.isEmpty((Collection)((List)properties.get("GROUPS")))) {
            builder.append(" GROUPS ");
            builder.append(String.join((CharSequence)", ", (List)properties.get("GROUPS")));
        }
        if (description != null && CommonUtils.isNotEmpty((String)description.toString())) {
            builder.append(" COMMENT ");
            builder.append(SQLUtils.quoteString((DBSObject)user, (String)description.toString()));
        }
    }

    @NotNull
    private String getUserName(CubridPrivilage user, Map<Object, Object> properties) {
        Object name = properties.get(CubridPrivilageHandler.NAME.getId());
        if (name != null) {
            user.setName(name.toString());
        }
        return user.getName();
    }
}

