/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.statistics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.features.DBRFeature;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureTracker;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.statistics.StatisticsTransmitter;
import org.jkiss.dbeaver.ui.statistics.UIStatisticsActivator;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class FeatureStatisticsCollector
implements DBRFeatureTracker {
    private static final Log log = Log.getLog(FeatureStatisticsCollector.class);
    private static final long TRACK_PERIOD = 5000L;
    public static final String ACTIVITY_LOGS_DIR = ".activity-logs";
    private static final boolean SEND_STATS_ON_SHUTDOWN = true;
    private final List<TrackingMessage> messages = new ArrayList<TrackingMessage>();
    private AbstractJob trackMonitor;
    private BufferedWriter trackStream;

    FeatureStatisticsCollector() {
    }

    void startMonitor() {
        if (this.trackMonitor != null) {
            this.trackMonitor.cancel();
        }
        this.trackMonitor = new AbstractJob("Features"){
            {
                this.setSystem(true);
                this.setUser(false);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                FeatureStatisticsCollector.this.flushStatistics();
                if (!this.isCanceled()) {
                    this.schedule(5000L);
                }
                return Status.OK_STATUS;
            }
        };
        this.trackMonitor.schedule(5000L);
    }

    void stopMonitor() {
        if (this.trackMonitor != null) {
            this.trackMonitor.cancel();
            this.trackMonitor = null;
        }
    }

    private BufferedWriter getTrackStream() throws IOException {
        if (this.trackStream == null) {
            Path logsDir = FeatureStatisticsCollector.getLogsFolder();
            Path logFile = logsDir.resolve(System.currentTimeMillis() / 1000L + "_" + DBWorkbench.getPlatform().getApplication().getApplicationRunId() + ".log");
            this.trackStream = Files.newBufferedWriter(logFile, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        return this.trackStream;
    }

    @NotNull
    static Path getLogsFolder() throws IOException {
        Path logsDir = GeneralUtils.getMetadataFolder().resolve(ACTIVITY_LOGS_DIR);
        if (!Files.exists(logsDir, new LinkOption[0])) {
            Files.createDirectories(logsDir, new FileAttribute[0]);
        }
        return logsDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushStatistics() {
        TrackingMessage[] messagesCopy;
        List<TrackingMessage> list = this.messages;
        synchronized (list) {
            if (this.messages.isEmpty()) {
                return;
            }
            messagesCopy = this.messages.toArray(new TrackingMessage[0]);
            this.messages.clear();
        }
        if (!UIStatisticsActivator.isTrackingEnabled()) {
            return;
        }
        try {
            BufferedWriter out = this.getTrackStream();
            TrackingMessage[] trackingMessageArray = messagesCopy;
            int n = messagesCopy.length;
            int n2 = 0;
            while (n2 < n) {
                TrackingMessage message = trackingMessageArray[n2];
                out.write(message.toPlainText());
                out.write("\n");
                ++n2;
            }
            out.flush();
        }
        catch (IOException e) {
            log.debug((Object)"Statistics flush error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackFeature(DBRFeature feature, Map<String, Object> parameters) {
        if (!UIStatisticsActivator.isTrackingEnabled()) {
            return;
        }
        List<TrackingMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(new TrackingMessage(feature, parameters));
        }
    }

    public void startTracking() {
        if (UIStatisticsActivator.isTrackingEnabled()) {
            this.startMonitor();
            this.sendCollectedStatistics(true);
        }
    }

    public void dispose() {
        this.stopMonitor();
        this.flushStatistics();
        if (this.trackStream != null) {
            try {
                this.trackStream.close();
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
            this.trackStream = null;
        }
        if (UIStatisticsActivator.isTrackingEnabled()) {
            this.sendCollectedStatistics(false);
        }
    }

    private void sendCollectedStatistics(boolean detached) {
        log.debug((Object)"send collected statistics");
        String workspaceId = BaseWorkspaceImpl.readWorkspaceIdProperty() + "-" + BaseWorkspaceImpl.getLocalHostId();
        new StatisticsTransmitter(workspaceId).send(detached);
    }

    private static class TrackingMessage {
        long timestamp = System.currentTimeMillis();
        DBRFeature feature;
        Map<String, Object> parameters;

        public TrackingMessage(DBRFeature feature, Map<String, Object> parameters) {
            this.feature = feature;
            this.parameters = parameters;
        }

        String toPlainText() {
            StringBuilder text = new StringBuilder();
            long appStartTime = this.timestamp - DBWorkbench.getPlatform().getApplication().getApplicationStartTime();
            text.append(appStartTime).append(":").append(this.feature.getId());
            if (this.parameters != null && !this.parameters.isEmpty()) {
                text.append(":");
                boolean first = true;
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    if (!first) {
                        text.append("&");
                    }
                    text.append(this.normalizeString(entry.getKey())).append("=").append(this.normalizeString(entry.getValue()));
                    first = false;
                }
            }
            return text.toString();
        }

        private String normalizeString(Object key) {
            if (key == null) {
                return "";
            }
            return key.toString().replace("\n", "\\n").replace("\r", "\\r").replace("&", "\\&").replace("=", "\\=");
        }
    }
}

