/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.function.BiConsumer;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;

public interface IObjectPropertyConfigurator<OBJECT, SETTINGS> {
    public void createControl(@NotNull Composite var1, OBJECT var2, @NotNull Runnable var3);

    public void loadSettings(@NotNull SETTINGS var1);

    public void saveSettings(@NotNull SETTINGS var1);

    public void resetSettings(@NotNull SETTINGS var1);

    public boolean isComplete();

    @Nullable
    default public String getErrorMessage() {
        return null;
    }

    default public DBPConnectionEditIntention getEditIntention() {
        return DBPConnectionEditIntention.DEFAULT;
    }

    public static <OBJECT, SETTINGS> IObjectPropertyConfigurator<OBJECT, SETTINGS> createPlaceholdingConfigurator(final BiConsumer<Composite, OBJECT> uiBuilder) {
        return new IObjectPropertyConfigurator<OBJECT, SETTINGS>(){

            @Override
            public void createControl(@NotNull Composite parent, OBJECT object, @NotNull Runnable propertyChangeListener) {
                uiBuilder.accept(parent, object);
            }

            @Override
            public void loadSettings(@NotNull SETTINGS settings) {
            }

            @Override
            public void saveSettings(@NotNull SETTINGS settings) {
            }

            @Override
            public void resetSettings(@NotNull SETTINGS settings) {
            }

            @Override
            public boolean isComplete() {
                return true;
            }
        };
    }
}

