/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.api;

import org.jkiss.code.NotNull;

public record DriverReference(@NotNull String providerId, @NotNull String driverId) {
    public static final DriverReference UNKNOWN = new DriverReference("", "");

    @NotNull
    public static DriverReference of(@NotNull String shortId) {
        String[] parts = shortId.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid driver reference: " + shortId + ", must be in a form of provider-id:driver-id");
        }
        return new DriverReference(parts[0], parts[1]);
    }

    @NotNull
    public String shortId() {
        return this.providerId + ":" + this.driverId;
    }

    @Override
    public String toString() {
        return this.shortId();
    }
}

