/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttributeIdentity;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandlerProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBECommandWithOptions;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreTableColumnManager
extends SQLTableColumnManager<PostgreTableColumn, PostgreTableBase>
implements DBEObjectRenamer<PostgreTableColumn>,
DBPScriptObjectExt2 {
    String OPTION_NON_STRUCT_CREATE_ACTION = "non.struct.create.action";
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDataTypeModifier = (monitor, column, sql, command) -> {
        String[] foreignTableColumnOptions;
        sql.append(' ');
        PostgreDataType dataType = column.getDataType();
        if (dataType != null) {
            sql.append(dataType.getFullyQualifiedName(DBPEvaluationContext.DDL));
            PostgreTypeHandler handler = PostgreTypeHandlerProvider.getTypeHandler(dataType);
            if (handler != null) {
                sql.append(handler.getTypeModifiersString(dataType, column.getTypeMod()));
            }
        } else {
            sql.append(column.getTypeName());
        }
        if (column.getTable() instanceof PostgreTableForeign && (foreignTableColumnOptions = column.getForeignTableColumnOptions()) != null && foreignTableColumnOptions.length != 0) {
            sql.append(" OPTIONS").append(PostgreUtils.getOptionsString(foreignTableColumnOptions));
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDefaultModifier = (monitor, column, sql, command) -> {
        String defaultValue = column.getDefaultValue();
        if (!CommonUtils.isEmpty((String)defaultValue) && defaultValue.startsWith("nextval") && PostgreConstants.SERIAL_TYPES.containsKey(column.getDataType().getName())) {
            return;
        }
        this.DefaultModifier.appendModifier(monitor, column, sql, command);
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreIdentityModifier = (monitor, column, sql, command) -> {
        PostgreAttributeIdentity identity = column.getIdentity();
        if (identity != null) {
            sql.append(" ").append(identity.getDefinitionClause());
        }
        if (column.getDepObjectId() != 0L) {
            try {
                PostgreTableBase table = column.getSchema().getTable(monitor, column.getDepObjectId());
                if (table instanceof PostgreSequence) {
                    sql.append("(");
                    ((PostgreSequence)table).getSequenceBody(monitor, sql, false);
                    sql.append(")");
                }
            }
            catch (DBException dBException) {
                log.debug((Object)"Can't find the depended object.");
            }
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreCollateModifier = (monitor, column, sql, command) -> {
        try {
            PostgreCollation collation = column.getCollation(monitor);
            if (collation != null && !"default".equals(collation.getName())) {
                sql.append(" COLLATE \"").append(collation.getName()).append("\"");
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreCommentModifier = (monitor, column, sql, command) -> {
        boolean createNonStructAction;
        String comment = column.getDescription();
        boolean bl = createNonStructAction = command instanceof DBECommandWithOptions && ((DBECommandWithOptions)command).getOptions().containsKey(this.OPTION_NON_STRUCT_CREATE_ACTION);
        if (!createNonStructAction && !CommonUtils.isEmpty((String)comment)) {
            sql.append(" -- ").append(CommonUtils.getSingleLineString((String)comment));
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreGeneratedModifier = (monitor, column, sql, command) -> {
        String generatedValue = column.getGeneratedValue();
        if (!CommonUtils.isEmpty((String)generatedValue)) {
            sql.append(" GENERATED ALWAYS AS (").append(generatedValue).append(") STORED");
        }
    };

    public boolean canEditObject(PostgreTableColumn object) {
        return true;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableColumn> getObjectsCache(PostgreTableColumn object) {
        return ((PostgreTableContainer)((PostgreTableBase)object.getParentObject()).getContainer()).getSchema().getTableCache().getChildrenCache((PostgreTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(PostgreTableColumn column, Map<String, Object> options) {
        Object[] modifiers = new SQLTableColumnManager.ColumnModifier[]{this.PostgreDataTypeModifier, this.PostgreDefaultModifier, this.PostgreIdentityModifier, this.PostgreCollateModifier, this.PostgreGeneratedModifier};
        if (column.getDataSource().getServerType().supportsColumnsRequiring()) {
            modifiers = (SQLTableColumnManager.ColumnModifier[])ArrayUtils.add(SQLTableColumnManager.ColumnModifier.class, (Object[])modifiers, (Object)this.NullNotNullModifier);
        }
        if (CommonUtils.getOption(options, (String)"ddl.includeComments")) {
            modifiers = (SQLTableColumnManager.ColumnModifier[])ArrayUtils.add(SQLTableColumnManager.ColumnModifier.class, (Object[])modifiers, this.PostgreCommentModifier);
        }
        return modifiers;
    }

    public StringBuilder getNestedDeclaration(@NotNull DBRProgressMonitor monitor, @NotNull PostgreTableBase owner, @NotNull DBECommandAbstract<PostgreTableColumn> command, @NotNull Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration(monitor, (DBSEntity)owner, command, options);
        PostgreAttribute cfr_ignored_0 = (PostgreAttribute)command.getObject();
        return decl;
    }

    protected PostgreTableColumn createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        PostgreTableColumn column;
        PostgreTableBase table = (PostgreTableBase)container;
        if (copyFrom instanceof PostgreTableColumn) {
            column = new PostgreTableColumn(monitor, table, (PostgreTableColumn)copyFrom);
        } else {
            column = new PostgreTableColumn(table);
            column.setName(this.getNewColumnName(monitor, context, table));
            PostgreDataType dataType = table.getDatabase().getDataType(monitor, 1043L);
            column.setDataType(dataType);
            column.setOrdinalPosition(-1);
        }
        return column;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        options.put(this.OPTION_NON_STRUCT_CREATE_ACTION, true);
        PostgreTableBase table = (PostgreTableBase)((PostgreTableColumn)command.getObject()).getParentObject();
        String sql = "ALTER " + table.getTableTypeName() + " " + DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ADD " + String.valueOf(this.getNestedDeclaration(monitor, table, (DBECommandAbstract<PostgreTableColumn>)command, options));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create new table column", sql));
        if (!CommonUtils.isEmpty((String)((PostgreTableColumn)command.getObject()).getDescription())) {
            PostgreTableColumnManager.addColumnCommentAction(actions, (PostgreAttribute)command.getObject());
        }
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        boolean isAtomic = column.getDataSource().getServerType().isAlterTableAtomic();
        PostgreTableBase table = (PostgreTableBase)column.getTable();
        String prefix = "ALTER " + table.getTableTypeName() + " " + DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String fullTypeName = column.getFullTypeName();
        Object typeClause = fullTypeName;
        if (column.getDataSource().getServerType().supportsAlterTableColumnWithUSING()) {
            typeClause = (String)typeClause + " USING ";
            typeClause = (String)typeClause + column.getDataSource().getSQLDialect().getTypeCastClause((DBSTypedObject)column, DBUtils.getQuotedIdentifier((DBSObject)column), true);
            typeClause = (String)typeClause + "::" + fullTypeName;
        }
        if (command.hasProperty((Object)"fullTypeName") || command.hasProperty((Object)"maxLength") || command.hasProperty((Object)"precision") || command.hasProperty((Object)"scale")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Set column type", prefix + "TYPE " + (String)typeClause, isAtomic));
        }
        if (command.hasProperty((Object)"required")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Set column nullability", prefix + (column.isRequired() ? "SET" : "DROP") + " NOT NULL", isAtomic));
        }
        if (command.hasProperty((Object)"defaultValue")) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Drop column default", prefix + "DROP DEFAULT", isAtomic));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Set column default", prefix + "SET DEFAULT " + column.getDefaultValue(), isAtomic));
            }
        }
        if (command.getProperty((Object)"description") != null) {
            PostgreTableColumnManager.addColumnCommentAction(actionList, column);
        }
    }

    public static void addColumnCommentAction(List<DBEPersistAction> actionList, PostgreAttribute column) {
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
        PostgreTableBase table = (PostgreTableBase)object.getTable();
        if (table.isPersisted() && table instanceof PostgreViewBase) {
            table.setObjectDefinitionText(null);
            commandContext.addCommand((DBECommand)new SQLObjectEditor.EmptyCommand((DBPObject)table), (DBECommandReflector)new SQLObjectEditor.RefreshObjectReflector(), true);
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        PostgreTableBase table = (PostgreTableBase)column.getTable();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER " + table.getTableTypeName() + " " + DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.includeComments".equals(option);
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        PostgreTableColumn column = (PostgreTableColumn)command.getObject();
        PostgreTableBase table = (PostgreTableBase)column.getParentObject();
        String ddl = "ALTER " + table.getTableTypeName() + " " + DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " DROP COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop table column", ddl));
    }
}

