/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.config.migration.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ext.config.migration.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ext.config.migration.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ConfigImportWizard
extends Wizard
implements IImportWizard {
    private static final Log log = Log.getLog(ConfigImportWizard.class);
    private ConfigImportWizardPage mainPage;
    private Map<String, DriverDescriptor> driverClassMap = new HashMap<String, DriverDescriptor>();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ImportConfigMessages.config_import_wizard_header_import_configuration);
        this.setNeedsProgressMonitor(true);
        this.mainPage = this.createMainPage();
    }

    protected abstract ConfigImportWizardPage createMainPage();

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        ImportData importData;
        block4: {
            this.mainPage.deactivatePage();
            importData = this.mainPage.getImportData();
            try {
                ImportConnectionInfo connectionInfo;
                Iterator<ImportConnectionInfo> iterator = importData.getConnections().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    DataSourceProviderRegistry.getInstance().saveDrivers();
                    break block4;
                } while (!(connectionInfo = iterator.next()).isChecked() || this.findOrCreateDriver(connectionInfo));
                return false;
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(ImportConfigMessages.config_import_wizard_import_driver, null, (Throwable)e);
                return false;
            }
        }
        for (ImportConnectionInfo connectionInfo : importData.getConnections()) {
            if (!connectionInfo.isChecked()) continue;
            this.importConnection(importData, connectionInfo);
        }
        return true;
    }

    private boolean findOrCreateDriver(ImportConnectionInfo connectionInfo) throws DBException {
        DriverDescriptor driver;
        ImportDriverInfo driverInfo = connectionInfo.getDriverInfo();
        if (CommonUtils.isEmpty((String)driverInfo.getDriverClass())) {
            throw new DBException("Cannot create driver '" + driverInfo.getName() + "' - no driver class specified");
        }
        String sampleURL = driverInfo.getSampleURL();
        if (CommonUtils.isEmpty((String)sampleURL)) {
            throw new DBException("Cannot create driver '" + driverInfo.getName() + "' - no connection URL pattern specified");
        }
        DriverDescriptor driver2 = this.driverClassMap.get(driverInfo.getDriverClass());
        if (driver2 != null) {
            connectionInfo.setDriver(driver2);
            return true;
        }
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        ArrayList<DriverDescriptor> matchedDrivers = new ArrayList<DriverDescriptor>();
        for (DataSourceProviderDescriptor dataSourceProvider : registry.getDataSourceProviders()) {
            for (DriverDescriptor driver3 : dataSourceProvider.getEnabledDrivers()) {
                String driverClassName = driver3.getDriverClassName();
                if (driverClassName == null || !driverClassName.equals(driverInfo.getDriverClass())) continue;
                matchedDrivers.add(driver3);
            }
        }
        if (matchedDrivers.isEmpty()) {
            DataSourceProviderDescriptor genericProvider = registry.getDataSourceProvider("generic");
            if (genericProvider == null) {
                throw new DBException("Generic datasource provider not found");
            }
            driver = genericProvider.createDriver();
            driver.setName(driverInfo.getName());
            driver.setDriverClassName(driverInfo.getDriverClass());
            driver.setSampleURL(driverInfo.getSampleURL());
            driver.setConnectionProperties(driverInfo.getProperties());
            driver.setDescription(driverInfo.getDescription());
            driver.setDriverDefaultPort(driverInfo.getDefaultPort());
            driver.setDriverDefaultDatabase(driverInfo.getDefaultDatabase());
            driver.setDriverDefaultServer(driverInfo.getDefaultServer());
            driver.setDriverDefaultUser(driverInfo.getDefaultUser());
            for (String path : driverInfo.getLibraries()) {
                driver.addDriverLibrary(path, DBPDriverLibrary.FileType.jar);
            }
            driver.setModified(true);
            genericProvider.addDriver(driver);
            connectionInfo.setDriver(driver);
        } else {
            driver = matchedDrivers.stream().filter(driverDescriptor -> driverDescriptor.getName().equalsIgnoreCase(driverInfo.getName())).findFirst().orElse((DriverDescriptor)matchedDrivers.get(0));
            connectionInfo.setDriver(driver);
        }
        if (driver != null) {
            this.driverClassMap.put(driver.getDriverClassName(), driver);
            return true;
        }
        return false;
    }

    private void importConnection(ImportData importData, ImportConnectionInfo connectionInfo) {
        try {
            this.adaptConnectionUrl(connectionInfo);
        }
        catch (DBException e) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)ImportConfigMessages.config_import_wizard_extract_url_parameters, (String)e.getMessage(), (int)8);
        }
        DBPDataSourceRegistry dataSourceRegistry = NavigatorUtils.getSelectedProject().getDataSourceRegistry();
        Object name = connectionInfo.getAlias();
        int i = 0;
        while (dataSourceRegistry.findDataSourceByName((String)name) != null) {
            name = connectionInfo.getAlias() + " " + (i + 1);
            ++i;
        }
        DBPConnectionConfiguration config = new DBPConnectionConfiguration();
        config.setProperties(connectionInfo.getProperties());
        config.setProviderProperties(connectionInfo.getProviderProperties());
        config.setUrl(connectionInfo.getUrl());
        config.setUserName(connectionInfo.getUser());
        config.setUserPassword(connectionInfo.getPassword());
        config.setHostName(connectionInfo.getHost());
        config.setHostPort(connectionInfo.getPort());
        config.setDatabaseName(connectionInfo.getDatabase());
        config.setAuthModelId(connectionInfo.getAuthModelId());
        config.setAuthProperties(connectionInfo.getAuthProperties());
        if (CommonUtils.isEmpty((String)connectionInfo.getHost())) {
            config.setConfigurationType(DBPDriverConfigurationType.URL);
        } else {
            config.setConfigurationType(DBPDriverConfigurationType.MANUAL);
        }
        if (!connectionInfo.getNetworkHandlers().isEmpty()) {
            config.setHandlers(connectionInfo.getNetworkHandlers());
        }
        DataSourceDescriptor dataSource = new DataSourceDescriptor(dataSourceRegistry, DataSourceDescriptor.generateNewId((DBPDriver)connectionInfo.getDriver()), (DBPDriver)connectionInfo.getDriver(), config);
        dataSource.setName((String)name);
        dataSource.setSavePassword(!CommonUtils.isEmpty((String)config.getUserPassword()));
        dataSource.setFolder(importData.getDataSourceFolder());
        try {
            dataSourceRegistry.addDataSource((DBPDataSourceContainer)dataSource);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(ImportConfigMessages.config_import_wizard_header_import_configuration, null, (Throwable)e);
        }
    }

    protected void adaptConnectionUrl(ImportConnectionInfo connectionInfo) throws DBException {
        String url = connectionInfo.getUrl();
        if (url == null) {
            if (connectionInfo.getDriver() == null) {
                throw new DBCException("Can't detect target driver for '" + connectionInfo.getAlias() + "'");
            }
            if (connectionInfo.getHost() == null) {
                throw new DBCException("No URL and no host name - can't import connection '" + connectionInfo.getAlias() + "'");
            }
            DBPConnectionConfiguration conConfig = new DBPConnectionConfiguration();
            conConfig.setHostName(connectionInfo.getHost());
            conConfig.setHostPort(connectionInfo.getPort());
            conConfig.setDatabaseName(connectionInfo.getDatabase());
            url = connectionInfo.getDriver().getConnectionURL(conConfig);
            connectionInfo.setUrl(url);
            return;
        }
        try {
            this.parseUrlAsDriverSampleUrl(connectionInfo);
            return;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.info((Object)("Import url as is it for url:" + url));
            return;
        }
    }

    private void parseUrlAsDriverSampleUrl(ImportConnectionInfo connectionInfo) throws DBException {
        Matcher matcher;
        String url = connectionInfo.getUrl();
        String sampleURL = connectionInfo.getDriverInfo().getSampleURL();
        if (connectionInfo.getDriver() != null) {
            sampleURL = connectionInfo.getDriver().getSampleURL();
        }
        if ((matcher = DatabaseURL.getPattern((String)sampleURL).matcher(url)).matches()) {
            connectionInfo.setHost(matcher.group("host"));
            connectionInfo.setPort(matcher.group("port"));
            connectionInfo.setDatabase(matcher.group("database"));
        }
    }
}

