/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class SQLQueryCompletionExtraTextProvider
implements SQLQueryCompletionItemVisitor<String> {
    public static SQLQueryCompletionExtraTextProvider INSTANCE = new SQLQueryCompletionExtraTextProvider();

    private SQLQueryCompletionExtraTextProvider() {
    }

    @NotNull
    public String visitSubqueryAlias(@Nullable SQLQueryCompletionItem.SQLRowsSourceAliasCompletionItem rowsSourceAlias) {
        return rowsSourceAlias.sourceInfo.tableOrNull != null ? " - Table alias" : " - Subquery alias";
    }

    @NotNull
    public String visitColumnName(@NotNull SQLQueryCompletionItem.SQLColumnNameCompletionItem columnName) {
        SQLQueryExprType type = columnName.columnInfo.type;
        String typeName = type == null || type == SQLQueryExprType.UNKNOWN ? null : type.getDisplayName();
        return typeName == null ? " - Column" : " : " + typeName;
    }

    @NotNull
    public String visitTableName(@NotNull SQLQueryCompletionItem.SQLTableNameCompletionItem tableName) {
        return DBUtils.isView((DBSEntity)tableName.table) ? " - View " : " - Table ";
    }

    @Nullable
    public String visitReservedWord(@Nullable SQLQueryCompletionItem.SQLReservedWordCompletionItem reservedWord) {
        return null;
    }

    @NotNull
    public String visitNamedObject(@NotNull SQLQueryCompletionItem.SQLDbNamedObjectCompletionItem namedObject) {
        DBSObject o = namedObject.object;
        String typeName = DBUtils.getObjectTypeName((DBSObject)o);
        if (typeName.equalsIgnoreCase("Object")) {
            typeName = o instanceof DBSSchema ? "Schema" : (o instanceof DBSCatalog ? "Catalog" : "");
        }
        return CommonUtils.isEmpty((String)typeName) ? null : " - " + typeName;
    }
}

