/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.erd.ui.ERDIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;

public class HandToolEntry
extends ToolEntry {
    public static final String ID = "hand-tool";

    public HandToolEntry() {
        super("Pan Diagram", "Pan diagram view", DBeaverIcons.getImageDescriptor((DBPImage)ERDIcon.MOVE), DBeaverIcons.getImageDescriptor((DBPImage)ERDIcon.MOVE), ToolHand.class);
        this.setUserModificationPermission(1);
        this.setId(ID);
    }

    public static class ToolHand
    extends AbstractTool {
        private int viewStartX;
        private int viewStartY;

        public ToolHand() {
            this.setDefaultCursor(Cursors.SIZEALL);
            this.setUnloadWhenFinished(false);
        }

        public void deactivate() {
            if (this.isInState(4)) {
                this.performAbort();
            }
            super.deactivate();
        }

        protected boolean handleButtonDown(int button) {
            if (button != 1) {
                this.setState(8);
            }
            if (this.stateTransition(1, 4)) {
                Point viewLocation = this.getViewLocation();
                this.viewStartX = viewLocation.x;
                this.viewStartY = viewLocation.y;
            }
            return true;
        }

        protected boolean handleButtonUp(int button) {
            this.stateTransition(4, 0x40000000);
            this.handleFinished();
            return true;
        }

        protected boolean handleDragInProgress() {
            if (this.isInState(6)) {
                this.performMove();
            }
            return true;
        }

        protected String getCommandName() {
            return "move";
        }

        private void performMove() {
            Point delta = this.getStartLocation().getTranslated(this.getLocation().getNegated());
            Point location = this.getStartViewLocation().getTranslated(delta);
            this.scrollViewTo(location);
        }

        private void performAbort() {
            this.scrollViewTo(this.getStartViewLocation());
        }

        private void scrollViewTo(@NotNull Point point) {
            FigureCanvas canvas = this.getCanvas();
            if (canvas != null) {
                canvas.scrollTo(point.x, point.y);
            }
        }

        @NotNull
        private Point getViewLocation() {
            FigureCanvas canvas = this.getCanvas();
            if (canvas != null) {
                return canvas.getViewport().getViewLocation().getCopy();
            }
            return new Point(0, 0);
        }

        @NotNull
        private Point getStartViewLocation() {
            return new Point(this.viewStartX, this.viewStartY);
        }

        @Nullable
        private FigureCanvas getCanvas() {
            Control control;
            EditPartViewer viewer = this.getCurrentViewer();
            if (viewer instanceof ScrollingGraphicalViewer && (control = viewer.getControl()) instanceof FigureCanvas) {
                return (FigureCanvas)control;
            }
            return null;
        }
    }
}

