/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.Collection;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.utils.ListNode;
import org.jkiss.utils.Pair;

public class SQLQueryModel
extends SQLQueryNodeModel {
    @NotNull
    private final Set<SQLQuerySymbolEntry> symbolEntries;
    @Nullable
    private final SQLQueryModelContent queryContent;

    public SQLQueryModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryModelContent queryContent, @NotNull Set<SQLQuerySymbolEntry> symbolEntries) {
        super(syntaxNode.getRealInterval(), syntaxNode, queryContent);
        this.queryContent = queryContent;
        this.symbolEntries = symbolEntries;
    }

    @NotNull
    public Collection<SQLQuerySymbolEntry> getAllSymbols() {
        return this.symbolEntries;
    }

    @Nullable
    public SQLQueryModelContent getQueryModel() {
        return this.queryContent;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return this.queryContent == null ? null : this.queryContent.getGivenDataContext();
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return this.queryContent == null ? null : this.queryContent.getResultDataContext();
    }

    public void propagateContext(@NotNull SQLQueryDataContext dataContext, @NotNull SQLQueryRecognitionContext recognitionContext) {
        if (this.queryContent != null) {
            this.queryContent.applyContext(dataContext, recognitionContext);
        }
    }

    public SQLQueryNodeModel findNodeContaining(int textOffset) {
        SQLQueryNodeModel node = this;
        SQLQueryNodeModel nested = node.findChildNodeContaining(textOffset);
        while (nested != null) {
            node = nested;
            nested = nested.findChildNodeContaining(textOffset);
        }
        return node;
    }

    public Pair<SQLQueryDataContext, SQLQueryLexicalScopeItem> findLexicalContext(int textOffset) {
        ListNode stack = ListNode.of((Object)this);
        SQLQueryNodeModel node = this;
        SQLQueryNodeModel nested = node.findChildNodeContaining(textOffset);
        while (nested != null) {
            stack = ListNode.push((ListNode)stack, (Object)nested);
            node = nested;
            nested = nested.findChildNodeContaining(textOffset);
        }
        SQLQueryDataContext deepestContext = ((SQLQueryNodeModel)node).getGivenDataContext();
        SQLQueryDataContext context = null;
        SQLQueryLexicalScopeItem lexicalItem = null;
        SQLQueryLexicalScope scope = null;
        while (stack != null && scope == null) {
            SQLQueryNodeModel node2 = (SQLQueryNodeModel)stack.data;
            scope = node2.findLexicalScope(textOffset);
            if (scope != null) {
                context = scope.getContext();
                lexicalItem = scope.findNearestItem(textOffset);
            }
            stack = stack.next;
        }
        if (context == null) {
            context = deepestContext;
        }
        return Pair.of((Object)context, lexicalItem);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitSelectionModel(this, arg);
    }
}

