/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteSubqueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class SourceResolutionResult {
    @NotNull
    public final SQLQueryRowsSourceModel source;
    @Nullable
    public final DBSEntity tableOrNull;
    @Nullable
    public final SQLQuerySymbol aliasOrNull;
    public final boolean isCteSubquery;

    private SourceResolutionResult(@NotNull SQLQueryRowsSourceModel source, @Nullable DBSEntity tableOrNull, @Nullable SQLQuerySymbol aliasOrNull) {
        this.source = source;
        this.tableOrNull = tableOrNull;
        this.aliasOrNull = aliasOrNull;
        this.isCteSubquery = source instanceof SQLQueryRowsCteSubqueryModel;
    }

    @NotNull
    public static SourceResolutionResult forRealTableByName(@NotNull SQLQueryRowsSourceModel source, @Nullable DBSEntity table) {
        return new SourceResolutionResult(source, table, null);
    }

    @NotNull
    public static SourceResolutionResult forSourceByAlias(@NotNull SQLQueryRowsSourceModel source, @Nullable SQLQuerySymbol alias) {
        return new SourceResolutionResult(source, null, alias);
    }

    @NotNull
    public static SourceResolutionResult withRealTable(@NotNull SourceResolutionResult rr, @Nullable DBSEntity table) {
        return new SourceResolutionResult(rr.source, table, rr.aliasOrNull);
    }

    @NotNull
    public static SourceResolutionResult withAlias(@NotNull SourceResolutionResult rr, @Nullable SQLQuerySymbol alias) {
        return new SourceResolutionResult(rr.source, rr.tableOrNull, alias);
    }
}

