/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryAliasedRowsContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryCombinedContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryPureResultTupleContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultTupleContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryTableRowsContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryWithUndresolvedSourceRowsContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.Pair;

public abstract class SQLQueryDataContext {
    @NotNull
    public abstract List<SQLQueryResultColumn> getColumnsList();

    public abstract boolean hasUndresolvedSource();

    @NotNull
    public abstract List<SQLQueryResultPseudoColumn> getPseudoColumnsList();

    @Nullable
    public abstract DBSEntity findRealTable(@NotNull DBRProgressMonitor var1, @NotNull List<String> var2);

    @Nullable
    public abstract DBSObject findRealObject(@NotNull DBRProgressMonitor var1, @NotNull DBSObjectType var2, @NotNull List<String> var3);

    @Nullable
    public abstract SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor var1, @NotNull String var2);

    @Nullable
    public abstract SQLQueryResultPseudoColumn resolvePseudoColumn(@NotNull DBRProgressMonitor var1, @NotNull String var2);

    @Nullable
    public abstract SQLQueryResultPseudoColumn resolveGlobalPseudoColumn(@NotNull DBRProgressMonitor var1, @NotNull String var2);

    @Nullable
    public SourceResolutionResult resolveSource(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        DBSEntity table = this.findRealTable(monitor, tableName);
        SQLQueryRowsSourceModel source = table == null ? null : this.findRealSource(table);
        return source == null ? null : SourceResolutionResult.forRealTableByName(source, table);
    }

    @Nullable
    public abstract SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity var1);

    @NotNull
    public final SQLQueryDataContext overrideResultTuple(@Nullable SQLQueryRowsSourceModel source, @NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns) {
        List allPseudoColumns = source == null ? pseudoColumns : STMUtils.combineLists(this.prepareRowsetPseudoColumns(source), pseudoColumns);
        return new SQLQueryResultTupleContext(this, columns, allPseudoColumns);
    }

    @NotNull
    public final SQLQueryDataContext overrideResultTuple(@Nullable SQLQueryRowsSourceModel source, @NotNull Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> columnsAndPseudoColumns) {
        return this.overrideResultTuple(source, (List)columnsAndPseudoColumns.getFirst(), (List)columnsAndPseudoColumns.getSecond());
    }

    @NotNull
    public final SQLQueryDataContext combine(@NotNull SQLQueryDataContext other) {
        return new SQLQueryCombinedContext(this, other);
    }

    @NotNull
    public final SQLQueryDataContext extendWithRealTable(@NotNull DBSEntity table, @NotNull SQLQueryRowsSourceModel source) {
        return new SQLQueryTableRowsContext(this, table, source);
    }

    @NotNull
    public final SQLQueryDataContext extendWithTableAlias(@NotNull SQLQuerySymbol alias, @NotNull SQLQueryRowsSourceModel source) {
        return new SQLQueryAliasedRowsContext(this, alias, source);
    }

    @NotNull
    public final SQLQueryDataContext hideSources() {
        return new SQLQueryPureResultTupleContext(this);
    }

    public final SQLQueryDataContext markHasUnresolvedSource() {
        return new SQLQueryWithUndresolvedSourceRowsContext(this);
    }

    @NotNull
    public abstract SQLDialect getDialect();

    public KnownSourcesInfo collectKnownSources() {
        KnownSourcesInfo result = new KnownSourcesInfo();
        this.collectKnownSourcesImpl(result);
        return result;
    }

    protected abstract void collectKnownSourcesImpl(@NotNull KnownSourcesInfo var1);

    protected abstract List<SQLQueryResultPseudoColumn> prepareRowsetPseudoColumns(@NotNull SQLQueryRowsSourceModel var1);

    public static class KnownSourcesInfo {
        @NotNull
        private final Map<SQLQueryRowsSourceModel, SourceResolutionResult> sources = new HashMap<SQLQueryRowsSourceModel, SourceResolutionResult>();
        @NotNull
        private final Set<DBSObject> referencedTables = new HashSet<DBSObject>();
        @NotNull
        private final Set<String> aliasesInUse = new HashSet<String>();
        private final Map<SQLQueryRowsSourceModel, SourceResolutionResult> sourcesView = Collections.unmodifiableMap(this.sources);
        private final Set<DBSObject> referencedTablesView = Collections.unmodifiableSet(this.referencedTables);
        private final Set<String> aliasesInUseView = Collections.unmodifiableSet(this.aliasesInUse);

        public void registerTableReference(@NotNull SQLQueryRowsSourceModel source, @NotNull DBSEntity table) {
            SQLQueryRowsCorrelatedSourceModel cc;
            SQLQueryRowsSourceModel sourceModel = source instanceof SQLQueryRowsCorrelatedSourceModel && (cc = (SQLQueryRowsCorrelatedSourceModel)source).getCorrelationColumNames().isEmpty() ? cc.getSource() : source;
            this.sources.compute(sourceModel, (k, v) -> v == null ? SourceResolutionResult.forRealTableByName(sourceModel, table) : SourceResolutionResult.withRealTable(v, table));
            this.referencedTables.add((DBSObject)table);
        }

        public void registerAlias(@NotNull SQLQueryRowsSourceModel source, @NotNull SQLQuerySymbol alias) {
            SQLQueryRowsCorrelatedSourceModel cc;
            SQLQueryRowsSourceModel sourceModel = source instanceof SQLQueryRowsCorrelatedSourceModel && (cc = (SQLQueryRowsCorrelatedSourceModel)source).getCorrelationColumNames().isEmpty() ? cc.getSource() : source;
            this.sources.compute(sourceModel, (k, v) -> v == null ? SourceResolutionResult.forSourceByAlias(sourceModel, alias) : SourceResolutionResult.withAlias(v, alias));
            this.aliasesInUse.add(alias.getName());
        }

        @NotNull
        public Map<SQLQueryRowsSourceModel, SourceResolutionResult> getResolutionResults() {
            return this.sourcesView;
        }

        @NotNull
        public Set<DBSObject> getReferencedTables() {
            return this.referencedTablesView;
        }

        @NotNull
        public Set<String> getAliasesInUse() {
            return this.aliasesInUseView;
        }
    }
}

