/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.commands;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.parser.rules.ScriptParameterRule;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCommandSet
implements SQLControlCommandHandler {
    @Override
    public boolean handleCommand(SQLControlCommand command, SQLScriptContext scriptContext) throws DBException {
        String parameter;
        SQLDialect sqlDialect = scriptContext.getExecutionContext().getDataSource().getSQLDialect();
        int varNameEnd = ScriptParameterRule.tryConsumeParameterName(sqlDialect, parameter = command.getParameter().stripLeading(), 0);
        if (varNameEnd == -1) {
            throw new DBCException("Missing variable name. Expected syntax:\n@set varName = value or expression");
        }
        String varName = parameter.substring(0, varNameEnd);
        int divPos = parameter.indexOf(61, varNameEnd);
        if (divPos == -1) {
            throw new DBCException("Bad set syntax. Expected syntax:\n@set varName = value or expression");
        }
        String shouldBeEmpty = parameter.substring(varNameEnd, divPos).trim();
        if (shouldBeEmpty.length() > 0) {
            throw new DBCException("Unexpected characters " + shouldBeEmpty + " after the variable name " + varName + ". Expected syntax:\n@set varName = value or expression");
        }
        String varValue = parameter.substring(divPos + 1).trim();
        varValue = GeneralUtils.replaceVariables((String)varValue, name -> CommonUtils.toString((Object)scriptContext.getVariable(name)), (boolean)true);
        scriptContext.setVariable(varName, varValue);
        return true;
    }

    @NotNull
    public static String prepareVarName(@NotNull SQLDialect sqlDialect, @NotNull String rawName) {
        if (sqlDialect.isQuotedIdentifier(rawName)) {
            return sqlDialect.getUnquotedIdentifier(rawName, true);
        }
        return rawName;
    }
}

