/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializer;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.VersionUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.xml.sax.Attributes;

public class DriverDescriptorSerializerLegacy
extends DriverDescriptorSerializer {
    public static final String DRIVERS_FILE_NAME = "drivers.xml";
    private static final Log log = Log.getLog(DriverDescriptorSerializerLegacy.class);

    @Override
    public void serializeDrivers(OutputStream os, List<DataSourceProviderDescriptor> providers) throws IOException {
        XMLBuilder xml = new XMLBuilder(os, GeneralUtils.UTF8_ENCODING);
        xml.setButify(true);
        xml.startElement("drivers");
        for (DataSourceProviderDescriptor provider : providers) {
            if (provider.isTemporary()) continue;
            List drivers = provider.getDrivers().stream().filter(DriverDescriptor::isModified).collect(Collectors.toList());
            drivers.removeIf(driverDescriptor -> driverDescriptor.getReplacedBy() != null);
            if (drivers.isEmpty()) continue;
            xml.startElement("provider");
            xml.addAttribute("id", provider.getId());
            for (DriverDescriptor driver : drivers) {
                this.serializeDriver(xml, driver, false);
            }
            xml.endElement();
        }
        xml.endElement();
        xml.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void serializeDriver(XMLBuilder xml, DriverDescriptor driver, boolean export) throws IOException {
        Map<String, String> pathSubstitutions = this.getPathSubstitutions();
        Throwable throwable = null;
        Object var6_7 = null;
        try (XMLBuilder.Element e0 = xml.startElement("driver");){
            XMLBuilder.Element e1;
            Object var11_29;
            Throwable throwable2;
            if (export) {
                xml.addAttribute("provider", driver.getProviderDescriptor().getId());
            }
            xml.addAttribute("id", driver.getId());
            if (driver.isDisabled()) {
                xml.addAttribute("disabled", true);
            }
            if (!CommonUtils.isEmpty((String)driver.getCategory())) {
                xml.addAttribute("category", driver.getCategory());
            }
            if (!CommonUtils.isEmpty(driver.getCategories())) {
                xml.addAttribute("categories", String.join((CharSequence)",", driver.getCategories()));
            }
            xml.addAttribute("name", driver.getName());
            if (!CommonUtils.isEmpty((String)driver.getDriverClassName())) {
                xml.addAttribute("class", driver.getDriverClassName());
            }
            if (!CommonUtils.isEmpty((String)driver.getSampleURL())) {
                xml.addAttribute("url", driver.getSampleURL());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultPort())) {
                xml.addAttribute("port", driver.getDefaultPort());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultDatabase())) {
                xml.addAttribute("defaultDatabase", driver.getDefaultDatabase());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultServer())) {
                xml.addAttribute("defaultServer", driver.getDefaultServer());
            }
            if (!CommonUtils.isEmpty((String)driver.getDefaultUser())) {
                xml.addAttribute("defaultUser", driver.getDefaultUser());
            }
            if (!CommonUtils.isEmpty((String)driver.getDescription())) {
                xml.addAttribute("description", driver.getDescription());
            }
            if (driver.isCustomDriverLoader()) {
                xml.addAttribute("customDriverLoader", driver.isCustomDriverLoader());
            }
            xml.addAttribute("custom", driver.isCustom());
            if (driver.isEmbedded()) {
                xml.addAttribute("embedded", driver.isEmbedded());
            }
            if (driver.isPropagateDriverProperties()) {
                xml.addAttribute("propagateDriverProperties", driver.isPropagateDriverProperties());
            }
            if (driver.isAnonymousAccess()) {
                xml.addAttribute("anonymous", driver.isAnonymousAccess());
            }
            if (driver.isAllowsEmptyPassword()) {
                xml.addAttribute("allowsEmptyPassword", driver.isAllowsEmptyPassword());
            }
            if (!driver.isInstantiable()) {
                xml.addAttribute("instantiable", driver.isInstantiable());
            }
            if (!driver.isSupportsDistributedMode()) {
                xml.addAttribute("supportsDistributedMode", driver.isSupportsDistributedMode());
            }
            if (driver.isThreadSafeDriver() != driver.isOrigThreadSafeDriver()) {
                xml.addAttribute("threadSafe", driver.isThreadSafeDriver());
            }
            for (DBPDriverLibrary dBPDriverLibrary : driver.getDriverLibraries()) {
                if (export && !dBPDriverLibrary.isDisabled()) continue;
                throwable2 = null;
                var11_29 = null;
                try {
                    e1 = xml.startElement("library");
                    try {
                        List<DriverDescriptor.DriverFileInfo> files;
                        xml.addAttribute("type", dBPDriverLibrary.getType().name());
                        xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, dBPDriverLibrary.getPath()));
                        xml.addAttribute("custom", dBPDriverLibrary.isCustom());
                        if (dBPDriverLibrary.isDisabled()) {
                            xml.addAttribute("disabled", true);
                        }
                        if (!CommonUtils.isEmpty((String)dBPDriverLibrary.getPreferredVersion())) {
                            xml.addAttribute("version", dBPDriverLibrary.getPreferredVersion());
                        }
                        if (dBPDriverLibrary instanceof DriverLibraryMavenArtifact) {
                            if (((DriverLibraryMavenArtifact)dBPDriverLibrary).isIgnoreDependencies()) {
                                xml.addAttribute("ignore-dependencies", true);
                            }
                            if (((DriverLibraryMavenArtifact)dBPDriverLibrary).isLoadOptionalDependencies()) {
                                xml.addAttribute("load-optional-dependencies", true);
                            }
                        }
                        if ((files = driver.getResolvedFiles().get(dBPDriverLibrary)) == null) continue;
                        for (DriverDescriptor.DriverFileInfo file : files) {
                            Throwable throwable3 = null;
                            Object var17_40 = null;
                            try (XMLBuilder.Element e2 = xml.startElement("file");){
                                if (file.getFile() == null) {
                                    log.warn((Object)("File missing in " + file.getId()));
                                    continue;
                                }
                                xml.addAttribute("id", file.getId());
                                if (!CommonUtils.isEmpty((String)file.getVersion())) {
                                    xml.addAttribute("version", file.getVersion());
                                }
                                xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, file.getFile().toString()));
                                if (file.getFileCRC() == 0L) continue;
                                xml.addAttribute("crc", Long.toHexString(file.getFileCRC()));
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            for (DBPNativeClientLocation dBPNativeClientLocation : driver.getNativeClientHomes()) {
                throwable2 = null;
                var11_29 = null;
                try {
                    e1 = xml.startElement("clientHome");
                    try {
                        xml.addAttribute("id", dBPNativeClientLocation.getName());
                        if (dBPNativeClientLocation.getPath() == null) continue;
                        xml.addAttribute("path", dBPNativeClientLocation.getPath().getAbsolutePath());
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable2 == null) {
                        throwable2 = throwable6;
                    } else if (throwable2 != throwable6) {
                        throwable2.addSuppressed(throwable6);
                    }
                    throw throwable2;
                }
            }
            for (Map.Entry entry : driver.getCustomParameters().entrySet()) {
                if (!driver.isCustom() && CommonUtils.equalObjects(entry.getValue(), (Object)driver.getDefaultParameters().get(entry.getKey()))) continue;
                throwable2 = null;
                var11_29 = null;
                try {
                    e1 = xml.startElement("parameter");
                    try {
                        xml.addAttribute("name", (String)entry.getKey());
                        xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            if (driver.isCustom()) {
                Throwable throwable8 = null;
                Iterator<Object> iterator = null;
                try (XMLBuilder.Element e12 = xml.startElement("parameter");){
                    xml.addAttribute("icon", driver.getIcon().getLocation());
                }
                catch (Throwable throwable82) {
                    void var8_20;
                    if (throwable8 == null) {
                        Throwable throwable9 = throwable82;
                    } else if (throwable8 != throwable82) {
                        throwable8.addSuppressed(throwable82);
                    }
                    throw var8_20;
                }
            }
            for (Map.Entry entry : driver.getConnectionProperties().entrySet()) {
                if (CommonUtils.equalObjects(entry.getValue(), (Object)driver.getDefaultConnectionProperties().get(entry.getKey()))) continue;
                throwable2 = null;
                var11_29 = null;
                try {
                    e1 = xml.startElement("property");
                    try {
                        xml.addAttribute("name", (String)entry.getKey());
                        xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable10) {
                    if (throwable2 == null) {
                        throwable2 = throwable10;
                    } else if (throwable2 != throwable10) {
                        throwable2.addSuppressed(throwable10);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable10) {
            if (throwable == null) {
                throwable = throwable10;
            } else if (throwable != throwable10) {
                throwable.addSuppressed(throwable10);
            }
            throw throwable;
        }
    }

    public static class DriversParser
    implements SAXListener {
        private final boolean providedDrivers;
        DataSourceProviderDescriptor curProvider;
        DriverDescriptor curDriver;
        DBPDriverLibrary curLibrary;
        private boolean isLibraryUpgraded = false;
        private final boolean isDistributed = DBWorkbench.isDistributed();
        private final boolean isDetachedProcess = DBWorkbench.getPlatform().getApplication().isDetachedProcess();
        private static final String PATH_VERSION_OBSOLETE_RELEASE = ":release";

        public DriversParser(boolean provided) {
            this.providedDrivers = provided;
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) {
            switch (localName) {
                case "provider": {
                    this.curProvider = null;
                    this.curDriver = null;
                    String idAttr = atts.getValue("id");
                    if (CommonUtils.isEmpty((String)idAttr)) {
                        log.warn((Object)"No id for driver provider");
                        return;
                    }
                    this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(idAttr);
                    if (this.curProvider != null || this.isDetachedProcess) break;
                    log.warn((Object)("Datasource provider '" + idAttr + "' not found. Bad provider description."));
                    break;
                }
                case "driver": {
                    this.curDriver = null;
                    String idAttr = atts.getValue("id");
                    if (this.curProvider == null) {
                        String providerId = atts.getValue("provider");
                        if (!CommonUtils.isEmpty((String)providerId)) {
                            this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
                            if (this.curProvider == null && !this.isDetachedProcess) {
                                log.warn((Object)("Datasource provider '" + providerId + "' not found. Bad driver description."));
                            }
                        }
                        if (this.curProvider == null) {
                            if (!this.isDetachedProcess) {
                                log.warn((Object)("Driver '" + idAttr + "' outside of datasource provider"));
                            }
                            return;
                        }
                    }
                    this.curDriver = this.curProvider.getDriver(idAttr);
                    if (this.curDriver == null) {
                        this.curDriver = new DriverDescriptor(this.curProvider, idAttr);
                        this.curProvider.addDriver(this.curDriver);
                    }
                    if (this.providedDrivers || this.curProvider.isDriversManagable()) {
                        String category = atts.getValue("category");
                        if (!CommonUtils.isEmpty((String)category)) {
                            this.curDriver.setCategory(category);
                        }
                        if (this.providedDrivers || this.curDriver.isCustom()) {
                            this.curDriver.setName(CommonUtils.toString((Object)atts.getValue("name"), (String)this.curDriver.getName()));
                        }
                        this.curDriver.setDescription(CommonUtils.toString((Object)atts.getValue("description"), (String)this.curDriver.getDescription()));
                        this.curDriver.setDriverClassName(CommonUtils.toString((Object)atts.getValue("class"), (String)this.curDriver.getDriverClassName()));
                        this.curDriver.setSampleURL(CommonUtils.toString((Object)atts.getValue("url"), (String)this.curDriver.getSampleURL()));
                        this.curDriver.setDriverDefaultPort(CommonUtils.toString((Object)atts.getValue("port"), (String)this.curDriver.getDefaultPort()));
                        this.curDriver.setDriverDefaultDatabase(CommonUtils.toString((Object)atts.getValue("defaultDatabase"), (String)this.curDriver.getDefaultDatabase()));
                        this.curDriver.setDriverDefaultServer(CommonUtils.toString((Object)atts.getValue("defaultServer"), (String)this.curDriver.getDefaultServer()));
                        this.curDriver.setDriverDefaultUser(CommonUtils.toString((Object)atts.getValue("defaultUser"), (String)this.curDriver.getDefaultUser()));
                        this.curDriver.setEmbedded(CommonUtils.getBoolean((String)atts.getValue("embedded"), (boolean)this.curDriver.isEmbedded()));
                        this.curDriver.setPropagateDriverProperties(CommonUtils.getBoolean((String)atts.getValue("propagateDriverProperties"), (boolean)this.curDriver.isPropagateDriverProperties()));
                        this.curDriver.setAnonymousAccess(CommonUtils.getBoolean((String)atts.getValue("anonymous"), (boolean)this.curDriver.isAnonymousAccess()));
                        this.curDriver.setAllowsEmptyPassword(CommonUtils.getBoolean((String)atts.getValue("allowsEmptyPassword"), (boolean)this.curDriver.isAllowsEmptyPassword()));
                        this.curDriver.setInstantiable(CommonUtils.getBoolean((String)atts.getValue("instantiable"), (boolean)this.curDriver.isInstantiable()));
                        this.curDriver.setThreadSafeDriver(CommonUtils.getBoolean((String)atts.getValue("threadSafe"), (boolean)this.curDriver.isThreadSafeDriver()));
                    }
                    if (atts.getValue("customDriverLoader") != null) {
                        this.curDriver.setCustomDriverLoader(CommonUtils.getBoolean((String)atts.getValue("customDriverLoader"), (boolean)false));
                    }
                    if (atts.getValue("useURL") != null) {
                        this.curDriver.setUseURL(CommonUtils.getBoolean((String)atts.getValue("useURL"), (boolean)true));
                    }
                    if (atts.getValue("supportsDistributedMode") != null) {
                        this.curDriver.setSupportsDistributedMode(CommonUtils.getBoolean((String)atts.getValue("supportsDistributedMode"), (boolean)true));
                    }
                    this.curDriver.setModified(true);
                    String disabledAttr = atts.getValue("disabled");
                    if (!CommonUtils.getBoolean((String)disabledAttr)) break;
                    this.curDriver.setDisabled(true);
                    break;
                }
                case "library": {
                    if (this.curDriver == null) {
                        if (!this.isDetachedProcess) {
                            log.warn((Object)("Library outside of driver (" + atts.getValue("path") + ")"));
                        }
                        return;
                    }
                    this.isLibraryUpgraded = false;
                    String typeStr = atts.getValue("type");
                    DBPDriverLibrary.FileType type = CommonUtils.isEmpty((String)typeStr) ? DBPDriverLibrary.FileType.jar : (DBPDriverLibrary.FileType)CommonUtils.valueOf(DBPDriverLibrary.FileType.class, (String)typeStr, (Enum)DBPDriverLibrary.FileType.jar);
                    String path = DriversParser.normalizeLibraryPath(atts.getValue("path"));
                    if (!CommonUtils.isEmpty((String)path)) {
                        path = DriverDescriptorSerializerLegacy.replacePathVariables(path);
                    }
                    boolean custom = CommonUtils.getBoolean((String)atts.getValue("custom"), (boolean)true);
                    String version = atts.getValue("version");
                    DBPDriverLibrary lib = this.curDriver.getDriverLibrary(path);
                    if (!(this.isDistributed || this.providedDrivers || custom || lib != null)) {
                        return;
                    }
                    if (this.providedDrivers && lib == null && !this.curDriver.getDriverLibraries().isEmpty()) {
                        this.curDriver.disabledAllDefaultLibraries();
                    }
                    String disabledAttr = atts.getValue("disabled");
                    if (lib != null && CommonUtils.getBoolean((String)disabledAttr)) {
                        lib.setDisabled(true);
                    } else if (lib == null) {
                        lib = DriverLibraryAbstract.createFromPath(this.curDriver, type, path, version);
                        this.curDriver.addDriverLibrary(lib, false);
                    } else if (!CommonUtils.isEmpty((String)version)) {
                        String preferredVersion = CommonUtils.toString((Object)lib.getPreferredVersion(), (String)"0");
                        int versionMatch = VersionUtils.compareVersions((String)version, (String)preferredVersion);
                        if (versionMatch > 0) {
                            lib.setPreferredVersion(version);
                        } else if (versionMatch < 0 && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.drivers.version.update")) {
                            lib.resetVersion();
                            this.isLibraryUpgraded = true;
                        }
                    }
                    if (lib instanceof DriverLibraryMavenArtifact) {
                        ((DriverLibraryMavenArtifact)lib).setIgnoreDependencies(CommonUtils.toBoolean((Object)atts.getValue("ignore-dependencies")));
                        ((DriverLibraryMavenArtifact)lib).setLoadOptionalDependencies(CommonUtils.toBoolean((Object)atts.getValue("load-optional-dependencies")));
                    }
                    this.curLibrary = lib;
                    break;
                }
                case "file": {
                    long crc;
                    String path;
                    if (this.curDriver == null || this.curLibrary == null || this.isLibraryUpgraded || (path = atts.getValue("path")) == null) break;
                    if (CommonUtils.isEmpty((String)(path = DriverDescriptorSerializerLegacy.replacePathVariables(path)))) {
                        log.warn((Object)"Empty path for library file");
                        break;
                    }
                    DriverDescriptor.DriverFileInfo info = new DriverDescriptor.DriverFileInfo(atts.getValue(CommonUtils.notEmpty((String)"id")), atts.getValue(CommonUtils.notEmpty((String)"version")), this.curLibrary.getType(), Path.of(path, new String[0]));
                    String crcString = atts.getValue("crc");
                    if (!CommonUtils.isEmpty((String)crcString) && (crc = Long.parseLong(crcString, 16)) != 0L) {
                        info.setFileCRC(crc);
                    }
                    this.curDriver.addLibraryFile(this.curLibrary, info);
                    break;
                }
                case "clientHome": {
                    if (this.curDriver == null) break;
                    this.curDriver.addNativeClientLocation((DBPNativeClientLocation)new LocalNativeClientLocation(atts.getValue("id"), atts.getValue("path")));
                    break;
                }
                case "parameter": {
                    String iconParam;
                    if (this.curDriver == null) break;
                    String paramName = atts.getValue("name");
                    String paramValue = atts.getValue("value");
                    if (!CommonUtils.isEmpty((String)paramName) && !CommonUtils.isEmpty((String)paramValue)) {
                        this.curDriver.setDriverParameter(paramName, paramValue, false);
                    }
                    if (!this.curDriver.isCustom() || CommonUtils.isEmpty((String)(iconParam = atts.getValue("icon")))) break;
                    DBPImage icon = this.curDriver.iconToImage(iconParam);
                    this.curDriver.setIconPlain(icon);
                    this.curDriver.makeIconExtensions();
                    break;
                }
                case "property": {
                    if (this.curDriver == null) break;
                    String paramName = atts.getValue("name");
                    String paramValue = atts.getValue("value");
                    if (CommonUtils.isEmpty((String)paramName)) break;
                    this.curDriver.setConnectionProperty(paramName, paramValue);
                }
            }
        }

        private static String normalizeLibraryPath(String value) {
            if (((String)value).startsWith("maven:/") && ((String)value).endsWith(PATH_VERSION_OBSOLETE_RELEASE)) {
                value = ((String)value).substring(0, ((String)value).length() - PATH_VERSION_OBSOLETE_RELEASE.length()) + ":RELEASE";
            }
            return value;
        }

        public void saxText(SAXReader reader, String data) {
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
            switch (localName) {
                case "library": {
                    this.curLibrary = null;
                }
            }
        }
    }
}

