/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class BasePolicyDataProvider {
    private static final Log log = Log.getLog(BasePolicyDataProvider.class);
    private static final String DBEAVER_REGISTRY_POLICY_NODE = "Software\\DBeaver Corp\\DBeaver\\policy";
    private static final BasePolicyDataProvider INSTANCE = new BasePolicyDataProvider();

    @NotNull
    public static BasePolicyDataProvider getInstance() {
        return INSTANCE;
    }

    private BasePolicyDataProvider() {
    }

    public boolean isPolicyEnabled(@NotNull String propertyName) {
        return this.convertToBooleanValue(this.getPolicyProperty(propertyName));
    }

    @Nullable
    public Object getPolicyValue(@NotNull String propertyName) {
        return this.getPolicyProperty(propertyName);
    }

    private boolean convertToBooleanValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String str = (String)value;
            return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("on") || str.equals("1");
        }
        if (value instanceof Number) {
            Number num = (Number)value;
            return num.intValue() > 0;
        }
        return CommonUtils.toBoolean((Object)value);
    }

    @Nullable
    public Object getPolicyProperty(@NotNull String property) {
        Object value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        value = BasePolicyDataProvider.getRegistryPolicyValue(WinReg.HKEY_CURRENT_USER, property);
        if (value != null) {
            return value;
        }
        value = BasePolicyDataProvider.getRegistryPolicyValue(WinReg.HKEY_LOCAL_MACHINE, property);
        return value;
    }

    @Nullable
    private static Object getRegistryPolicyValue(@NotNull WinReg.HKEY root, @NotNull String property) {
        if (!RuntimeUtils.isWindows()) {
            return null;
        }
        try {
            if (Advapi32Util.registryKeyExists((WinReg.HKEY)root, (String)DBEAVER_REGISTRY_POLICY_NODE) && Advapi32Util.registryValueExists((WinReg.HKEY)root, (String)DBEAVER_REGISTRY_POLICY_NODE, (String)property)) {
                return Advapi32Util.registryGetValue((WinReg.HKEY)root, (String)DBEAVER_REGISTRY_POLICY_NODE, (String)property);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error reading Windows registry", e);
        }
        return null;
    }
}

